/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.spox.listeners;

import java.util.HashMap;
import java.util.Map;
import uk.gov.hmrc.chris.spox.DefaultListener;
import uk.gov.hmrc.chris.spox.SPOXException;
import uk.gov.hmrc.chris.spox.listeners.processing.Appender;
import uk.gov.hmrc.chris.spox.listeners.processing.NodeModifier;
import uk.gov.hmrc.chris.spox.listeners.processing.PostXpathProcessor;
import uk.gov.hmrc.chris.spox.listeners.processing.Reporter;
import uk.gov.hmrc.chris.spox.xml.Attribute;
import uk.gov.hmrc.chris.utils.config.ChRISNode;
import uk.gov.hmrc.chris.utils.xml.ManagedXMLOutputStream;
import uk.gov.hmrc.chris.utils.xml.XMLBuilder;
import uk.gov.hmrc.chris.utils.xml.XMLProcessingException;

public class XMLFragmentExtractor
extends DefaultListener {
    protected XMLBuilder xml = null;
    protected boolean inSideXpath = false;
    protected Map<String, Reporter> xPaths = new HashMap<String, Reporter>();
    protected NodeModifier modifier;
    protected Map<String, Integer> report = new HashMap<String, Integer>();
    protected PostXpathProcessor processor;
    protected int currentDepth = 0;
    protected Appender appender;
    protected String xpath;
    protected ManagedXMLOutputStream destination;

    public XMLFragmentExtractor(ChRISNode config, ManagedXMLOutputStream destination, NodeModifier modfier, PostXpathProcessor addProcessor) {
        ChRISNode[] xPathElements = config.getXPaths("Copy/Element");
        this.modifier = modfier;
        this.processor = addProcessor;
        for (ChRISNode node : xPathElements) {
            String xPath = node.getXPath("Xpath").getValue();
            ChRISNode reporterNode = node.getXPath("Reporter");
            if (reporterNode != null) {
                Reporter reporter = Reporter.Factory.newInstance(node.getXPath("Reporter").getValue());
                this.xPaths.put(xPath, reporter);
                continue;
            }
            this.xPaths.put(xPath, null);
        }
        try {
            this.destination = destination;
            this.xml = new XMLBuilder((Boolean)false, destination);
        }
        catch (XMLBuilder.XMLBuilderException e) {
            throw new SPOXException("Exception occurred while intialisaing XMLBuilder. ", e);
        }
    }

    public void setOverrideEndDocument(boolean overrideEndDocument) {
        this.xml.setOverrideEndDocument(overrideEndDocument);
    }

    @Override
    public void startElementFound(String name, Attribute ... attributes) throws SPOXException {
        String finalName = this.checkForModification(name);
        if (this.inSideXpath) {
            ++this.currentDepth;
            try {
                this.xml.writeStartElement(finalName);
                boolean ignoreAttributes = this.checkIfIgnoreAllAttributes(name);
                if (!ignoreAttributes) {
                    for (Attribute attr : attributes) {
                        this.xml.writeAttribute(attr.getName(), attr.getValue());
                    }
                }
            }
            catch (XMLBuilder.XMLBuilderException e) {
                throw new SPOXException("Unable to write to the outputstream", e);
            }
        }
    }

    @Override
    public void endElementFound(String name) throws SPOXException {
        if (this.inSideXpath) {
            try {
                this.processElement(name, this.xml);
                this.xml.writeEndElement();
            }
            catch (XMLBuilder.XMLBuilderException e) {
                throw new SPOXException("Unable to write to the outputstream", e);
            }
        }
    }

    @Override
    public void characterDataFound(char[] data, int Size) throws SPOXException {
        if (this.inSideXpath) {
            try {
                this.xml.writeChars(data, 0, Size);
            }
            catch (XMLBuilder.XMLBuilderException e) {
                throw new SPOXException("Unable to write to the outputstream", e);
            }
        }
    }

    @Override
    public void xpathFound(String xpath) throws SPOXException {
        if (this.xPaths.keySet().contains(xpath)) {
            this.xpath = xpath;
            this.inSideXpath = true;
            this.reportXpathFound(this.xml);
            Reporter reporter = this.xPaths.get(xpath);
            if (reporter != null) {
                reporter.consume(xpath);
            }
            try {
                this.destination.addOneToCount();
            }
            catch (XMLProcessingException e) {
                throw new SPOXException("Exception occurred extracting information", e);
            }
        }
    }

    @Override
    public void xpathFinished() throws SPOXException {
        if (this.inSideXpath) {
            this.reportXpathFinished(this.xml);
        }
        this.inSideXpath = false;
        this.currentDepth = 0;
        this.xpath = null;
        try {
            this.xml.flush();
        }
        catch (XMLBuilder.XMLBuilderException e) {
            throw new SPOXException("Exception occurred while flushing ", e);
        }
    }

    @Override
    public void documentFinished() throws SPOXException {
        try {
            if (this.appender != null) {
                for (Reporter reporter : this.xPaths.values()) {
                    this.appender.append(this.xml, reporter);
                    reporter.reset();
                }
            }
            this.xml.endDocument();
        }
        catch (XMLBuilder.XMLBuilderException e) {
            throw new SPOXException("Exception occured while ending the document.", e);
        }
    }

    @Override
    public String[] getXPaths() throws SPOXException {
        return this.xPaths.keySet().toArray(new String[0]);
    }

    private String checkForModification(String name) {
        if (this.modifier == null) {
            return name;
        }
        return this.modifier.checkForModification(name);
    }

    private boolean checkIfIgnoreAllAttributes(String nodeName) {
        if (this.modifier == null) {
            return false;
        }
        return this.modifier.checkIfIgnoreAllAttributes(nodeName);
    }

    @Override
    public Object getResults() {
        HashMap<String, Object> reports = new HashMap<String, Object>();
        for (Reporter reporter : this.xPaths.values()) {
            if (reporter == null || !reporter.hasAnythingToreport()) continue;
            reports.put(reporter.getConsumed(), reporter.getCollected());
        }
        return reports;
    }

    protected void reportXpathFound(XMLBuilder builder) {
        if (this.processor != null) {
            this.processor.reportXpathfound(this.xpath, builder);
        }
    }

    protected void reportXpathFinished(XMLBuilder builder) {
        if (this.processor != null) {
            this.processor.reportXpathFinished(this.xpath, builder);
        }
    }

    protected void processElement(String elementName, XMLBuilder builder) {
        if (this.processor != null) {
            this.processor.processElement(elementName, builder);
        }
    }

    public void setAppender(Appender append) {
        this.appender = append;
    }

    public void setDestinationManager() {
    }
}

