/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.spox.listeners;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import uk.gov.hmrc.chris.spox.Listener;
import uk.gov.hmrc.chris.spox.xml.Attribute;

public class XPathListener
implements Listener {
    private HashMap<String, XPathData> xPathData = new HashMap();
    private XPathData data;
    private boolean xPathFound;

    public void addXPath(String xPath) {
        this.xPathData.put(xPath, new XPathData());
    }

    @Override
    public void characterDataFound(char[] data, int Size) {
        if (this.xPathFound) {
            this.data.addXPathValue(data);
        }
    }

    @Override
    public void xpathFound(String xpath) {
        if (this.xPathData.containsKey(xpath)) {
            this.data = this.xPathData.get(xpath);
            this.xPathFound = true;
        }
    }

    @Override
    public void xpathFinished() {
        this.xPathFound = false;
        this.data = null;
    }

    @Override
    public void documentStarted() {
    }

    @Override
    public void documentFinished() {
    }

    @Override
    public void reset() {
        this.xPathData = new HashMap();
        this.xPathFound = false;
        this.data = null;
    }

    @Override
    public void nameSpaceFound() {
    }

    @Override
    public void nameSpaceFinished() {
    }

    @Override
    public String[] getXPaths() {
        return this.xPathData.keySet().toArray(new String[this.xPathData.size()]);
    }

    @Override
    public void endElementFound(String name) {
        if (this.xPathFound) {
            this.data.save();
        }
    }

    @Override
    public void startElementFound(String name, Attribute ... attributes) {
    }

    @Override
    public String getNameSpace() {
        return null;
    }

    public Map<String, String[]> getResults() {
        HashMap<String, String[]> results = new HashMap<String, String[]>();
        for (String key : this.xPathData.keySet()) {
            XPathData data = this.xPathData.get(key);
            results.put(key, data.getXPathValues());
        }
        return results;
    }

    @Override
    public void commentFound(char[] arg0, int start, int length) {
    }

    public class XPathData {
        private ArrayList<String> xPathValues = new ArrayList();
        private StringBuffer xPathData = new StringBuffer();

        public String[] getXPathValues() {
            return this.xPathValues.toArray(new String[this.xPathValues.size()]);
        }

        public void addXPathValue(char[] value) {
            this.xPathData.append(value);
        }

        public void save() {
            if (this.xPathData.length() > 0) {
                this.xPathValues.add(this.xPathData.toString());
                this.xPathData.delete(0, this.xPathData.length());
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            for (int x = 0; x < this.xPathValues.size(); ++x) {
                sb.append(this.xPathValues.get(x));
            }
            return "Returned Values = (" + sb.toString() + ")";
        }
    }
}

