/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.spox.listeners.processing;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NodeModifier {
    private List mutators = new ArrayList();
    private Map attributeMutators = new HashMap();

    public void addModifier(String original, String replace) {
        this.mutators.add(new Modifier(original, replace));
    }

    public String checkForModification(String original) {
        for (Modifier m : this.mutators) {
            if (!m.getOriginal().equalsIgnoreCase(original)) continue;
            return m.getReplace();
        }
        return original;
    }

    public void addAttributeModifier(String nodeName, boolean ignoreAllAttributes) {
        this.attributeMutators.put(nodeName, new AttributeModifier(nodeName, ignoreAllAttributes));
    }

    public void addAttributeModifier(String nodeName, String originalAttrName, String replaceAttrName, String replaceAttrValue) {
        this.attributeMutators.put(nodeName + ";" + originalAttrName, new AttributeModifier(nodeName, originalAttrName, replaceAttrName, replaceAttrValue));
    }

    public boolean checkIfIgnoreAllAttributes(String nodeName) {
        if (this.attributeMutators.containsKey(nodeName)) {
            return ((AttributeModifier)this.attributeMutators.get(nodeName)).isIgnoreAllAttributes();
        }
        return false;
    }

    private class AttributeModifier {
        String nodeName = null;
        boolean ignoreAllAttributes = false;
        String originalAttrName = null;
        String replaceAttrName = null;
        String replaceAttrValue = null;

        public AttributeModifier(String nodeName, boolean ignoreAllAttributes) {
            this.nodeName = nodeName;
            this.ignoreAllAttributes = ignoreAllAttributes;
        }

        public AttributeModifier(String nodeName, String originalAttrName, String replaceAttrName, String replaceAttrValue) {
            this.nodeName = nodeName;
            this.originalAttrName = originalAttrName;
            this.replaceAttrName = replaceAttrName;
            this.replaceAttrValue = replaceAttrValue;
        }

        public String getOriginalAttrName() {
            return this.originalAttrName;
        }

        public String getReplaceAttrName() {
            return this.replaceAttrName;
        }

        public String getReplaceAttrValue() {
            return this.replaceAttrValue;
        }

        public boolean isIgnoreAllAttributes() {
            return this.ignoreAllAttributes;
        }
    }

    private class Modifier {
        String original = null;
        String replace = null;

        public Modifier(String original, String replace) {
            this.original = original;
            this.replace = replace;
        }

        public String getOriginal() {
            return this.original;
        }

        public String getReplace() {
            return this.replace;
        }
    }
}

