/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.spox.validation;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import uk.gov.hmrc.chris.ChRISExceptionLogger;
import uk.gov.hmrc.chris.SystemException;
import uk.gov.hmrc.chris.spox.validation.ChRISDefaultValidationHandler;
import uk.gov.hmrc.chris.spox.validation.SchemaError;
import uk.gov.hmrc.chris.utils.envelopeGenerators.ChRISErrorGenerator;
import uk.gov.hmrc.chris.utils.envelopeGenerators.EnvelopeGeneratorException;
import uk.gov.hmrc.chris.utils.xml.XMLBuilder;

class SAXValidationHandler
extends ChRISDefaultValidationHandler {
    private static final String ERRORS_ROOT_NODE = "Errors";
    private static final String ERRORS_XMLNS_ATTRIBUTE = "xmlns";
    private static final String ERRORS_XMLNS_NAMESPACE_ATTRIBUTE = "http://www.hmrc.gov.uk/ChRIS/Errors";
    private static final String ERRORS_XMLNS_XSI_ATTRIBUTE = "xmlns:xsi";
    private static final String ERRORS_XMLNS_XSI_NAMESPACE_ATTRIBUTE = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String DEFAULT_ERROR_RAISED_BY = "HMRC-ERIC";
    private static final String DEFAULT_ERROR_TYPE = "Schema Validation";
    private static final int DEFAULT_ERROR_NUMBER = 5012;
    private String errorRaisedBy = "HMRC-ERIC";
    private String errorType = "Schema Validation";
    private int errorNumber = 5012;
    private XMLBuilder builder;
    private int numErrors = 0;
    private String noNamespaceSchemaLocation;

    private SAXValidationHandler() {
        this(null);
    }

    private SAXValidationHandler(OutputStream errorOutputStream) {
        try {
            this.builder = errorOutputStream != null ? new XMLBuilder((Boolean)false, errorOutputStream) : new XMLBuilder();
        }
        catch (XMLBuilder.XMLBuilderException e) {
            throw new SystemException("Error creating XMLBuilder", e);
        }
        try {
            this.builder.writeStartElement(ERRORS_ROOT_NODE);
            this.builder.writeAttribute(ERRORS_XMLNS_ATTRIBUTE, ERRORS_XMLNS_NAMESPACE_ATTRIBUTE);
            this.builder.writeAttribute(ERRORS_XMLNS_XSI_ATTRIBUTE, ERRORS_XMLNS_XSI_NAMESPACE_ATTRIBUTE);
        }
        catch (XMLBuilder.XMLBuilderException e) {
            throw new SystemException("Error generating error XML", e);
        }
    }

    public static final SAXValidationHandler getInstance() {
        return new SAXValidationHandler();
    }

    public static final SAXValidationHandler getInstance(OutputStream errorOutputStream) {
        return new SAXValidationHandler(errorOutputStream);
    }

    public InputStream getSchemaErrors() {
        return this.builder.toInputSTream();
    }

    public int getNumErrors() {
        return this.numErrors;
    }

    public void setErrorRaisedBy(String errorRaisedBy) {
        this.errorRaisedBy = errorRaisedBy;
    }

    public void setErrorType(String errorType) {
        this.errorType = errorType;
    }

    public void setErrorNumber(int errorNumber) {
        this.errorNumber = errorNumber;
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.builder.endDocument();
        }
        catch (XMLBuilder.XMLBuilderException e) {
            throw new SystemException("Error ending document", e);
        }
    }

    @Override
    public InputSource resolveEntity(String publicID, String systemID) throws SAXException, IOException {
        ChRISExceptionLogger.debug("Resolving entity: publicID = '" + publicID + "'; " + "systemID = '" + systemID + "'");
        if (!systemID.startsWith("file:") && this.getNoNamespaceSchemaLocation() != null) {
            File file = new File(this.getNoNamespaceSchemaLocation());
            String absolutepath = file.getAbsolutePath();
            return new InputSource(absolutepath);
        }
        return new InputSource(systemID);
    }

    @Override
    public void error(SAXParseException spex) throws SAXException {
        super.error(spex);
        SchemaError error = new SchemaError(spex.getLineNumber(), spex.getColumnNumber(), spex.getMessage());
        this.writeError(error);
        ++this.numErrors;
    }

    @Override
    public void fatalError(SAXParseException spex) throws SAXException {
        super.error(spex);
        SchemaError error = new SchemaError(spex.getLineNumber(), spex.getColumnNumber(), spex.getMessage());
        this.writeError(error);
        ++this.numErrors;
    }

    private void writeError(SchemaError error) {
        ChRISErrorGenerator generator = new ChRISErrorGenerator();
        generator.setRaisedBy(this.errorRaisedBy);
        generator.setType(this.errorType);
        generator.setNumber(this.errorNumber);
        generator.setText(error.getErrorMessage());
        generator.setLocation(error.getLine() + ":" + error.getColumn());
        try {
            generator.generate(this.builder);
        }
        catch (EnvelopeGeneratorException e) {
            throw new SystemException("Error generating error XML", e);
        }
    }

    public String getNoNamespaceSchemaLocation() {
        return this.noNamespaceSchemaLocation;
    }

    public void setNoNamespaceSchemaLocation(String noNamespaceSchemaLocation) {
        this.noNamespaceSchemaLocation = noNamespaceSchemaLocation;
    }
}

