/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.spox.validation;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import uk.gov.hmrc.chris.SystemException;
import uk.gov.hmrc.chris.spox.SPOXException;
import uk.gov.hmrc.chris.spox.validation.SAXValidationHandler;

public class XMLValidationParser {
    private String schemaLocation;
    private String noNamespaceSchemaLocation;
    private InputStream schemaErrors;
    private static final String LEXICAL_HANDLER_KEY = "http://xml.org/sax/properties/lexical-handler";
    private static final String SCHEMA_LOCATION_KEY = "http://apache.org/xml/properties/schema/external-schemaLocation";
    private static final String NO_NAMESPACE_SCHEMA_LOCATION_KEY = "http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation";
    private static final String ERR_CREATING_XML_READER_MSG = "Error creating XMLReader";
    private static final String ERR_SPOX_PARSING_MSG = "An error occured in SPOX while parsing the XML";

    private XMLValidationParser(String schemaLocation, String noNamespaceSchemaLocation) {
        this.schemaLocation = schemaLocation;
        this.noNamespaceSchemaLocation = noNamespaceSchemaLocation;
    }

    public static final XMLValidationParser getInstance(String schemaLocation, String noNamespaceSchemaLocation) {
        return new XMLValidationParser(schemaLocation, noNamespaceSchemaLocation);
    }

    public int validateXML(InputStream xmlPayload) {
        return this.validateXML(xmlPayload, null);
    }

    public int validateXML(InputStream xmlPayload, OutputStream errorStream) {
        SAXValidationHandler handler = errorStream == null ? SAXValidationHandler.getInstance() : SAXValidationHandler.getInstance(errorStream);
        handler.setNoNamespaceSchemaLocation(this.noNamespaceSchemaLocation);
        XMLReader xmlReader = this.createXmlReader(handler);
        try {
            xmlReader.parse(new InputSource(xmlPayload));
        }
        catch (SAXException ex) {
            throw new SPOXException(ERR_SPOX_PARSING_MSG, ex);
        }
        catch (IOException ex) {
            throw new SPOXException(ERR_SPOX_PARSING_MSG, ex);
        }
        return handler.getNumErrors();
    }

    private XMLReader createXmlReader(SAXValidationHandler handler) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(true);
            factory.setNamespaceAware(true);
            XMLReader xmlReader = factory.newSAXParser().getXMLReader();
            xmlReader.setContentHandler(handler);
            xmlReader.setErrorHandler(handler);
            xmlReader.setFeature("http://apache.org/xml/features/validation/schema", true);
            xmlReader.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
            xmlReader.setProperty(LEXICAL_HANDLER_KEY, handler);
            xmlReader.setProperty(SCHEMA_LOCATION_KEY, this.schemaLocation);
            xmlReader.setProperty(NO_NAMESPACE_SCHEMA_LOCATION_KEY, this.noNamespaceSchemaLocation);
            xmlReader.setEntityResolver(handler);
            return xmlReader;
        }
        catch (ParserConfigurationException ex) {
            throw new SystemException(ERR_CREATING_XML_READER_MSG, ex);
        }
        catch (SAXException ex) {
            throw new SystemException(ERR_CREATING_XML_READER_MSG, ex);
        }
    }

    public InputStream getSchemaErrors() {
        if (this.schemaErrors == null) {
            throw new IllegalStateException("A call to this method may only be made after a successful call to validateXML(InputStream)");
        }
        return this.schemaErrors;
    }
}

