/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.spox.xml;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import uk.gov.hmrc.chris.spox.xml.Attribute;
import uk.gov.hmrc.chris.utils.xml.XMLBuilder;

public class Node {
    private String namespace;
    private String nodeXpath;
    private Node parent;
    private String name;
    private ArrayList<Attribute> attributes = new ArrayList();
    private HashMap<String, List<Node>> children = new LinkedHashMap<String, List<Node>>();
    private StringBuffer characterData = new StringBuffer();

    public Node(String name, Attribute ... attributes) {
        this.name = name;
        if (attributes != null) {
            for (int x = 0; x < attributes.length; ++x) {
                this.attributes.add(attributes[x]);
            }
        }
    }

    public Node(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Attribute[] getAttributes() {
        return this.attributes.toArray(new Attribute[this.attributes.size()]);
    }

    private void setParent(Node parent) {
        this.parent = parent;
    }

    public Node getParent() {
        return this.parent;
    }

    public void addChild(Node child) {
        child.setParent(this);
        if (this.children.containsKey(child.getName())) {
            List<Node> list = this.children.get(child.getName());
            list.add(child);
        } else {
            ArrayList<Node> list = new ArrayList<Node>();
            list.add(child);
            this.children.put(child.getName(), list);
        }
    }

    public List<Node> getChild(String child) {
        return this.children.get(child);
    }

    public void addCharacterData(char[] data) {
        this.characterData.append(data);
    }

    public String getCharacterData() {
        return this.characterData.toString();
    }

    public void setCharacterData(String pCharacterData) {
        this.characterData = new StringBuffer(pCharacterData);
    }

    public String toXML() throws NodeException {
        try {
            XMLBuilder builder = new XMLBuilder();
            this.toXML(builder);
            return new String(builder.getBytes(), 0, builder.getBufferSize(), "UTF-8");
        }
        catch (XMLBuilder.XMLBuilderException e) {
            throw new NodeException("Could not create XMLBuilder object", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new NodeException("Could not encode xml document returned from XMLBuilder", e);
        }
    }

    private void toXML(XMLBuilder xmlBuilder) throws XMLBuilder.XMLBuilderException {
        String charData;
        xmlBuilder.writeStartElement(this.getName());
        if (this.attributes != null) {
            for (int x = 0; x < this.attributes.size(); ++x) {
                Attribute att = this.attributes.get(x);
                xmlBuilder.writeAttribute(att.getName(), att.getValue());
            }
        }
        if ((charData = this.getCharacterData()) != null) {
            char[] characters = charData.toCharArray();
            xmlBuilder.writeChars(characters, 0, characters.length);
        }
        for (List<Node> childNodes : this.children.values()) {
            for (int x = 0; x < childNodes.size(); ++x) {
                Node child = childNodes.get(x);
                child.toXML(xmlBuilder);
            }
        }
        xmlBuilder.writeEndElement();
    }

    public String toString() {
        try {
            return this.toXML();
        }
        catch (NodeException e) {
            throw new RuntimeException("Could not translate this object into an XML string.", e);
        }
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public Node searchSubNode(Node node) {
        Node finished = null;
        for (List<Node> childNodes : this.children.values()) {
            for (int x = 0; x < childNodes.size(); ++x) {
                String nonFQName;
                Node child = childNodes.get(x);
                String string = nonFQName = child != null ? child.getName() : "";
                if (nonFQName != null && nonFQName.indexOf(58) != -1) {
                    nonFQName = nonFQName.substring(nonFQName.indexOf(58) + 1);
                }
                if (node.getName().equals(nonFQName)) {
                    node.setCharacterData(child != null ? child.getCharacterData() : null);
                    return node;
                }
                Node node2 = finished = child != null ? child.searchSubNode(node) : null;
                if (finished == null) continue;
                return finished;
            }
        }
        return null;
    }

    public HashMap<String, List<Node>> getChildren() {
        return this.children;
    }

    public String getNodeXpath() {
        return this.nodeXpath;
    }

    public void setNodeXpath(String nodeXpath) {
        this.nodeXpath = nodeXpath;
    }

    public static class NodeException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public NodeException(String message) {
            super(message, null);
        }

        public NodeException(String message, Throwable e) {
            super(message, e);
        }
    }
}

