/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.spox.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import uk.gov.hmrc.chris.spox.xml.XPathChunk;

public class XPath {
    private List<XPathChunk> chunks = null;
    private int currentOffset = 0;
    public int chunkLength;

    public XPath(String fullXPath) {
        ArrayList<XPathChunk> tempChunks = new ArrayList<XPathChunk>();
        StringTokenizer xpathTokens = new StringTokenizer(fullXPath, "/");
        int elementsCount = xpathTokens.countTokens();
        this.chunks = new ArrayList<XPathChunk>(elementsCount);
        for (int i = 0; i < elementsCount; ++i) {
            String chunk = xpathTokens.nextToken();
            if (chunk.indexOf("[") >= 0) {
                while (chunk.indexOf("]") == -1) {
                    chunk = chunk + xpathTokens.nextToken();
                    ++i;
                }
            }
            ++this.currentOffset;
            tempChunks.add(new XPathChunk(chunk));
        }
        this.chunks = new ArrayList<XPathChunk>(tempChunks.size());
        for (XPathChunk xPathChunk : tempChunks) {
            this.chunks.add(xPathChunk);
        }
    }

    public XPath(int size) {
        this.chunks = new ArrayList<XPathChunk>(size);
    }

    public List<XPathChunk> getChunks() {
        return this.chunks;
    }

    public int getChunkLength() {
        return this.currentOffset;
    }

    public boolean equals(XPath xpathIn) {
        List<XPathChunk> tempChunks = xpathIn.getChunks();
        if (this.getChunkLength() != xpathIn.getChunkLength()) {
            return false;
        }
        for (int i = this.getChunkLength() - 1; i >= 0; --i) {
            XPathChunk remoteChunk;
            XPathChunk localChunk = this.chunks.get(i);
            if (localChunk.equals(remoteChunk = tempChunks.get(i))) continue;
            return false;
        }
        return true;
    }

    public boolean checkLastElement(String name) {
        XPathChunk lastElement = this.chunks.get(this.chunks.size() - 1);
        return name.indexOf(lastElement.getChunkName()) != -1;
    }

    public void addChunk(XPathChunk xpc) {
        ++this.currentOffset;
        this.chunks.add(xpc);
    }

    public void removeChunk() {
        if (this.currentOffset > 0) {
            --this.currentOffset;
            this.chunks.remove(this.currentOffset);
        }
    }

    public String toString() {
        String retString = "";
        for (int i = 0; i < this.currentOffset; ++i) {
            XPathChunk chunk = this.chunks.get(i);
            retString = retString + "/" + chunk.toString();
        }
        return retString;
    }
}

