/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.spox.xml;

import java.util.StringTokenizer;
import uk.gov.hmrc.chris.spox.utils.SPOXUtils;
import uk.gov.hmrc.chris.spox.xml.Attribute;

public class XPathChunk {
    private String chunkName = null;
    private String fullChunkName = null;
    private Attribute[] attributes = null;

    public XPathChunk(String chunkName) {
        StringTokenizer chunk = new StringTokenizer(chunkName, " []\"=\u00a3");
        this.chunkName = SPOXUtils.stripNameSpaceFromNode(chunk.nextToken());
        int numberOfAttributes = chunk.countTokens() / 2;
        if (numberOfAttributes > 0) {
            this.attributes = new Attribute[numberOfAttributes];
            for (int i = 0; i < this.attributes.length; ++i) {
                String name = chunk.nextToken();
                String value = chunk.nextToken();
                this.attributes[i] = new Attribute(name, value);
            }
        }
    }

    public XPathChunk(String chunkName, Attribute ... attributes) {
        this.chunkName = SPOXUtils.stripNameSpaceFromNode(chunkName);
        this.attributes = attributes;
    }

    public boolean containsAttribute(Attribute remoteAttribute) {
        if (this.attributes != null) {
            for (int i = 0; i < this.attributes.length; ++i) {
                Attribute localAttribute = this.attributes[i];
                if (!remoteAttribute.equals(localAttribute)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean equals(XPathChunk remoteChunk) {
        if (!this.chunkName.equalsIgnoreCase(remoteChunk.getChunkName())) {
            return remoteChunk.getChunkName().equalsIgnoreCase("wildCard") || this.chunkName.equalsIgnoreCase("wildCard");
        }
        Attribute[] remoteAttributes = remoteChunk.getAttributes();
        if (remoteAttributes != null && remoteAttributes.length > 0) {
            for (int j = 0; j < remoteAttributes.length; ++j) {
                if (this.containsAttribute(remoteAttributes[j])) continue;
                return false;
            }
        }
        return true;
    }

    public Attribute[] getAttributes() {
        if (this.attributes == null) {
            this.attributes = new Attribute[0];
        }
        return this.attributes;
    }

    public String getChunkName() {
        return this.chunkName;
    }

    public String toString() {
        if (this.fullChunkName == null) {
            this.fullChunkName = this.chunkName;
            if (this.attributes != null) {
                for (int i = 0; i < this.attributes.length; ++i) {
                    Attribute attr = this.attributes[i];
                    this.fullChunkName = this.fullChunkName + " " + attr.getName() + "=[\"" + attr.getValue() + "\"]";
                }
            }
        }
        return this.fullChunkName;
    }
}

