/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.spox.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import uk.gov.hmrc.chris.spox.utils.SPOXUtils;
import uk.gov.hmrc.chris.spox.xml.Attribute;
import uk.gov.hmrc.chris.spox.xml.XPath;
import uk.gov.hmrc.chris.spox.xml.XPathChunk;

public class XPathMonitor {
    private Map<String, List<XPath>> XPathMap = new HashMap<String, List<XPath>>();
    private Stack<String> currentXPathStack = new Stack();
    private XPath stackXPath = new XPath(30);
    private int xpathCount = 0;

    public void addXpath(String ... xpathList) {
        String singleXPath = null;
        XPath xpw = null;
        List<XPath> xpaths = null;
        for (int i = 0; i < xpathList.length; ++i) {
            singleXPath = xpathList[i];
            xpw = new XPath(singleXPath);
            String XpathLength = Integer.toString(xpw.getChunkLength());
            xpaths = this.XPathMap.get(XpathLength);
            if (xpaths == null) {
                ArrayList<XPath> tempXpathList = new ArrayList<XPath>();
                this.XPathMap.put(Integer.toString(xpw.getChunkLength()), tempXpathList);
                tempXpathList.add(xpw);
                ++this.xpathCount;
                continue;
            }
            xpaths.add(xpw);
            ++this.xpathCount;
        }
    }

    public void pushOnElement(String element, Attribute ... attributes) {
        this.currentXPathStack.push(SPOXUtils.stripNameSpaceFromNode(element));
        this.stackXPath.addChunk(new XPathChunk(element, attributes));
    }

    public String popOffElement() {
        this.stackXPath.removeChunk();
        return this.currentXPathStack.pop();
    }

    public String checkForMatch() {
        List<XPath> xpathsToCheck = this.XPathMap.get(Integer.toString(this.currentXPathStack.size()));
        if (xpathsToCheck == null || xpathsToCheck.size() < 1) {
            return null;
        }
        for (XPath tempXPath : xpathsToCheck) {
            if (!tempXPath.checkLastElement(this.currentXPathStack.peek()) || !this.stackXPath.equals(tempXPath)) continue;
            return tempXPath.toString();
        }
        return null;
    }

    public boolean moreXPathsToProcess() {
        return this.xpathCount > 0;
    }
}

