/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.stax;

import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import uk.gov.hmrc.chris.ChRISBaseLogger;
import uk.gov.hmrc.chris.stax.XpathStack;
import uk.gov.hmrc.chris.utils.events.CharacterDataEvent;
import uk.gov.hmrc.chris.utils.events.ElementAttribute;
import uk.gov.hmrc.chris.utils.events.ElementNamespace;
import uk.gov.hmrc.chris.utils.events.EndElementEvent;
import uk.gov.hmrc.chris.utils.events.StartElementEvent;
import uk.gov.hmrc.chris.utils.xml.XMLBuilder;

public abstract class StaxXMLReader {
    protected XMLStreamReader xmlr;
    protected String key;
    private static final XMLInputFactory xmlif = StaxXMLReader.getFactory();
    protected boolean isInXpath = false;
    private boolean stoped = false;
    XpathStack stack = new XpathStack();
    protected Map<String, String> registeredXpaths = new HashMap<String, String>();
    protected Map<String, String> results = new HashMap<String, String>();

    protected StaxXMLReader(InputStream source) throws XMLStreamException {
        this.initXMLReader(source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StaxXMLReader(Reader reader) throws XMLStreamException {
        XMLInputFactory xMLInputFactory = xmlif;
        synchronized (xMLInputFactory) {
            this.xmlr = xmlif.createXMLStreamReader(reader);
        }
    }

    protected StaxXMLReader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initXMLReader(InputStream source) throws XMLStreamException {
        XMLInputFactory xMLInputFactory = xmlif;
        synchronized (xMLInputFactory) {
            this.xmlr = xmlif.createXMLStreamReader(source, "UTF-8");
        }
    }

    private static XMLInputFactory getFactory() {
        XMLInputFactory xmlif = XMLInputFactory.newInstance();
        xmlif.setProperty("javax.xml.stream.isReplacingEntityReferences", Boolean.TRUE);
        xmlif.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        xmlif.setProperty("javax.xml.stream.isNamespaceAware", Boolean.TRUE);
        xmlif.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        return xmlif;
    }

    public void pull() throws XMLStreamException {
        while (this.xmlr.hasNext() && !this.stoped) {
            this.handleEvent(this.xmlr.next());
        }
    }

    protected final void handleEvent(int eventType) throws XMLStreamException {
        switch (eventType) {
            case 1: {
                this.startElementFound();
                break;
            }
            case 2: {
                this.endElementFound();
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.charactersFound();
                break;
            }
            case 5: {
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                this.endDocument();
                break;
            }
            case 9: {
                System.out.println("ENTITY_REFERENCE");
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                this.cDataFound();
                break;
            }
            default: {
                throw new RuntimeException("Unrecoginsed event received while parsing");
            }
        }
    }

    protected void startElementFound() {
        String currentBranch = this.stack.push(this.xmlr.getLocalName());
        if (this.matchXpath(currentBranch)) {
            this.xPathFound(currentBranch);
        }
        this.handleAttributes();
    }

    protected void endElementFound() {
        this.popElement(this.xmlr.getLocalName());
    }

    protected abstract void charactersFound() throws XMLStreamException;

    protected void cDataFound() {
        System.out.println("Cdata Found");
    }

    private boolean matchXpath(String currentBranch) {
        if (this.registeredXpaths.keySet().contains(currentBranch)) {
            this.isInXpath = true;
            this.key = this.registeredXpaths.get(currentBranch);
            return true;
        }
        return false;
    }

    private void handleAttributes() {
        int attsCount = this.xmlr.getAttributeCount();
        String attName = null;
        String attVal = null;
        for (int i = 0; i < attsCount; ++i) {
            attName = this.xmlr.getAttributeLocalName(i);
            String currentBranch = this.stack.pushAttributeName(attName);
            this.matchXpath(currentBranch);
            attVal = this.xmlr.getAttributeValue(i);
            currentBranch = this.stack.pushAttributeValue(attVal);
            this.matchXpath(currentBranch);
            this.popAttributes(attName, attVal);
        }
    }

    private void popElement(String name) {
        if (this.isInXpath && this.matchXpath(this.stack.getCurrentXpath())) {
            this.isInXpath = false;
            this.key = null;
            this.xPathFinished(this.stack.getCurrentXpath());
        }
        this.stack.pop(name);
    }

    private void popAttributes(String attName, String attVal) {
        this.stack.popAttribute(attName, attVal);
    }

    public Map<String, String> getRsults() {
        return this.results;
    }

    protected String currentXpath() {
        return this.stack.getCurrentXpath();
    }

    protected abstract void xPathFound(String var1);

    protected abstract void xPathFinished(String var1);

    protected abstract void startDocument(String var1);

    public void stopPlease() {
        if (this.xmlr != null) {
            try {
                this.xmlr.close();
            }
            catch (XMLStreamException e) {
                ChRISBaseLogger.warning(e.getMessage());
            }
        }
    }

    protected void buildXML(List<Object> events, XMLBuilder builder) throws XMLBuilder.XMLBuilderException {
        for (Object obj : events) {
            if (obj instanceof StartElementEvent) {
                List<ElementNamespace> elementNamespace;
                StartElementEvent startElementEvent = (StartElementEvent)obj;
                builder.writeStartElement(startElementEvent.getElementName());
                List<ElementAttribute> elementAttribute = startElementEvent.getElementAttribute();
                if (elementAttribute != null) {
                    for (ElementAttribute attribute : elementAttribute) {
                        if (attribute.getAttributePrefix() != null) {
                            builder.writeAttribute(attribute.getAttributePrefix() + ":" + attribute.getAttributeLocalName(), attribute.getAttributeValue());
                            continue;
                        }
                        builder.writeAttribute(attribute.getAttributeLocalName(), attribute.getAttributeValue());
                    }
                }
                if ((elementNamespace = startElementEvent.getElementNamespace()) == null) continue;
                for (ElementNamespace namespace : elementNamespace) {
                    String namespacePrefix = "xmlns";
                    if (namespace.getNamespacePrefix() != null && !namespace.getNamespacePrefix().equals("")) {
                        namespacePrefix = namespacePrefix + ":" + namespace.getNamespacePrefix();
                    }
                    builder.writeAttribute(namespacePrefix, namespace.getNamespaceURI());
                }
                continue;
            }
            if (obj instanceof EndElementEvent) {
                builder.writeEndElement();
                continue;
            }
            if (!(obj instanceof CharacterDataEvent)) continue;
            String st = obj.toString();
            if (st.length() > 300) {
                builder.writeCData(obj.toString());
                continue;
            }
            builder.writeText(obj.toString());
        }
    }

    public abstract void endDocument();
}

