/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class DateUtils {
    public static final String TAXYEAR_DATE_FORMAT = "yyyy";
    private static final String GATEWAY_TIMESTAMP_1 = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private static final String GATEWAY_TIMESTAMP_2 = "yyyy-MM-dd'T'HH:mm:ss:SSS";
    private static final String GATEWAY_TIMESTAMP_3 = "yyyy-MM-dd'T'HH:mm:ss.SS";
    private static final String GATEWAY_TIMESTAMP_4 = "yyyy-MM-dd'T'HH:mm:ss";
    private static final String GATEWAY_TIMESTAMP_5 = "yyyy-MM-dd HH:mm:ss:SSS";
    private static final String GATEWAY_TIMESTAMP_6 = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final String GATEWAY_TIMESTAMP_7 = "yyyy-MM-dd HH:mm:ss";
    private static final String GATEWAY_TIMESTAMP_8 = "yyyyMMdd HH:mm:ss";
    public static final String XSD_DATE_FORMAT = "yyyy-MM-dd";
    public static final String XSD_DATE_TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    public static final String[] dateFormats = new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSS", "yyyy-MM-dd'T'HH:mm:ss:SSS", "yyyy-MM-dd'T'HH:mm:ss.SS", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd HH:mm:ss:SSS", "yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd HH:mm:ss", "yyyyMMdd HH:mm:ss", "yyyy-MM-dd"};

    public static final Date getEndOfTaxYearDate(Date date) {
        Calendar taxDate = Calendar.getInstance();
        taxDate.setTime(date);
        if (taxDate.get(2) > 3 || taxDate.get(2) == 3 && taxDate.get(5) > 5) {
            taxDate.add(1, 1);
        }
        Calendar endOfThisTaxYear = Calendar.getInstance();
        endOfThisTaxYear.set(5, 5);
        endOfThisTaxYear.set(2, 3);
        endOfThisTaxYear.set(1, taxDate.get(1));
        return endOfThisTaxYear.getTime();
    }

    public static final int getEndOfTaxYear(Date date) {
        Calendar taxDate = Calendar.getInstance();
        taxDate.setTime(date);
        if (taxDate.get(2) > 3 || taxDate.get(2) == 3 && taxDate.get(5) > 5) {
            taxDate.add(1, 1);
        }
        Calendar endOfThisTaxYear = Calendar.getInstance();
        endOfThisTaxYear.set(5, 5);
        endOfThisTaxYear.set(2, 3);
        endOfThisTaxYear.set(1, taxDate.get(1));
        return endOfThisTaxYear.get(1);
    }

    public static final Calendar getSpecifiedCalendar(int day, int month, int year) {
        Calendar messageReceivedCal = Calendar.getInstance();
        messageReceivedCal.set(5, day);
        messageReceivedCal.set(2, month);
        messageReceivedCal.set(1, year);
        return messageReceivedCal;
    }

    public static final Date getSpecifiedDate(int day, int month, int year) {
        Calendar cal = DateUtils.getSpecifiedCalendar(day, month, year);
        return cal.getTime();
    }

    public static final String formatDate(String dateFormat, Date dateToBeFormatted) throws DateUtilsException {
        if (dateFormat == null || dateToBeFormatted == null) {
            throw new DateUtilsException("The values supplied are incorrect [dateFormat = " + dateFormat + "], [dateToBeFormatted = " + dateToBeFormatted + "]");
        }
        DateFormat df = DateUtils.getFormatter(dateFormat);
        return df.format(dateToBeFormatted);
    }

    private static final DateFormat getFormatter(String format) {
        SimpleDateFormat df = new SimpleDateFormat(format);
        df.setCalendar(new GregorianCalendar());
        return df;
    }

    public static final String formatGatewayTimestamp(Date dateToBeFormatted) throws DateUtilsException {
        return DateUtils.formatDate("yyyy-MM-dd'T'HH:mm:ss.SSS", dateToBeFormatted);
    }

    private static boolean validateLength(String date, String format) {
        boolean failedParse = false;
        StringBuffer strippedFormat = new StringBuffer(format);
        int position = 0;
        while ((position = strippedFormat.indexOf("'")) != -1) {
            strippedFormat.deleteCharAt(position);
        }
        if (date.length() < strippedFormat.length()) {
            return false;
        }
        if (date.length() > strippedFormat.length()) {
            return false;
        }
        return !failedParse;
    }

    public static Date parseDate(String source, String format) throws DateUtilsException {
        return DateUtils.parseDate(source, format, false);
    }

    public static Date parseDate(String source, String format, boolean lenient) throws DateUtilsException {
        if (source == null || source.trim().length() == 0 || format == null || format.trim().length() == 0) {
            throw new DateUtilsException("Source or format string was null.  Date to be formated : " + source + ".  Format to use " + format);
        }
        if (!lenient && !DateUtils.validateLength(source, format)) {
            throw new DateUtilsException("Date string could not be parsed.  Date: " + source + ", Format: " + format);
        }
        try {
            DateFormat sdf = DateUtils.getFormatter(format);
            sdf.setLenient(lenient);
            return sdf.parse(source);
        }
        catch (ParseException e) {
            throw new DateUtilsException("Date string could not be parsed.  Date: " + source + ", Format: " + format);
        }
    }

    public static Date parseGatewayDate(String dateTime) throws DateUtilsException {
        boolean valid = false;
        Date parsedDate = null;
        if (dateTime == null || dateTime.trim().length() == 0) {
            throw new DateUtilsException("Date string to be formated was null");
        }
        for (String currDateFormat : dateFormats) {
            try {
                parsedDate = DateUtils.parseDate(dateTime, currDateFormat, false);
                valid = true;
                break;
            }
            catch (DateUtilsException e) {
            }
        }
        if (!valid) {
            for (String currDateFormat : dateFormats) {
                try {
                    parsedDate = DateUtils.parseDate(dateTime, currDateFormat, true);
                    valid = true;
                    break;
                }
                catch (DateUtilsException e) {
                }
            }
            if (valid && !DateUtils.isFirstDayOfBritishSummerTime(parsedDate)) {
                valid = false;
            }
        }
        if (!valid) {
            throw new DateUtilsException("Could not parse the date string  (" + dateTime + ") provided using any " + "of the following formats " + Arrays.toString(dateFormats));
        }
        return parsedDate;
    }

    public static boolean isFirstDayOfBritishSummerTime(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        int dayOfWeek = cal.get(7);
        int dayOfMonth = cal.get(5);
        int month = cal.get(2);
        return month == 2 && dayOfMonth >= 25 && dayOfWeek == 1;
    }

    public static java.sql.Date createSQLDate(Date date) {
        if (date == null) {
            return null;
        }
        return new java.sql.Date(date.getTime());
    }

    public static Timestamp createTimeStamp(Date date) {
        if (date == null) {
            return null;
        }
        return new Timestamp(date.getTime());
    }

    public static Calendar toCalendar(Date d) {
        if (d == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        return cal;
    }

    public static Date toDate(Calendar c) {
        if (c == null) {
            return null;
        }
        return c.getTime();
    }

    public static java.sql.Date toSqlDate(Date d) {
        if (d == null) {
            return null;
        }
        return new java.sql.Date(d.getTime());
    }

    public static Calendar stringToCalendar(String d) throws DateUtilsException {
        Date gatewayDate;
        if (d == null) {
            return null;
        }
        try {
            gatewayDate = DateUtils.parseGatewayDate(d);
        }
        catch (DateUtilsException e) {
            throw new DateUtilsException("Could not be parse Date string : " + d + " " + e);
        }
        return DateUtils.toCalendar(gatewayDate);
    }

    public static Date addSubtractDays(Date d, int days) throws DateUtilsException {
        if (d == null) {
            return null;
        }
        try {
            int i;
            Calendar cal = Calendar.getInstance();
            cal.setTime(d);
            if (days > 0) {
                for (i = 0; i < days; ++i) {
                    cal.add(5, 1);
                }
            }
            if (days < 0) {
                for (i = 0; i > days; --i) {
                    cal.add(5, -1);
                }
            }
            return cal.getTime();
        }
        catch (Exception e) {
            throw new DateUtilsException("Problem with adding/subtracting days service. " + e);
        }
    }

    public static Date resetTime(Date date) {
        Calendar calendar = DateUtils.toCalendar(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static class DateUtilsException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public DateUtilsException(String message) {
            super(message, null);
        }
    }
}

