/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.JNDIUsage;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import javax.sql.DataSource;
import uk.gov.hmrc.chris.utils.JNDIUsage.JNDIUsageException;

public class JNDIUsage {
    private static String JNDI_FACTORY = "weblogic.jndi.WLInitialContextFactory";
    private static final String DEFAULT_IP = "default_ip";
    private static JNDIUsage mJNDIUsage = new JNDIUsage();
    private static Map<String, InitialContext> mInitialContexts = Collections.synchronizedMap(new HashMap());
    private static Map<String, DataSource> mDataSources = Collections.synchronizedMap(new HashMap());
    private static Map<String, Object> mNarrowedObjects = Collections.synchronizedMap(new HashMap());
    public static JNDIUsage instance;

    private JNDIUsage() {
    }

    public static JNDIUsage getInstance() {
        return mJNDIUsage;
    }

    public Object narrow(Object ref, Class c) {
        if (ref == null || c == null) {
            throw new JNDIUsageException("The required params were incorrect: [ref= " + ref + ", class=" + c + " ]", null);
        }
        if (mNarrowedObjects.containsKey(ref.getClass().getName() + c.getName())) {
            return mNarrowedObjects.get(ref.getClass().getName() + c.getName());
        }
        try {
            Object narrowed = PortableRemoteObject.narrow((Object)ref, (Class)c);
            mNarrowedObjects.put(ref.getClass().getName() + c.getName(), narrowed);
            return narrowed;
        }
        catch (Exception e) {
            throw new JNDIUsageException("narrow: Could not narrow:", e);
        }
    }

    public Context getInitialContext(String pUrl) {
        return JNDIUsage.getCachedInitialContext(pUrl);
    }

    private DataSource getDataSource(String pUrl, String pDatasourceName) {
        Context ctx = this.getInitialContext(pUrl);
        return JNDIUsage.getCachedDataSource(ctx, pDatasourceName);
    }

    public Connection getConnection(String pUrl, String pDatasourceName) {
        DataSource datasource = this.getDataSource(pUrl, pDatasourceName);
        Connection conn = null;
        try {
            conn = datasource.getConnection();
        }
        catch (SQLException sqle) {
            throw new JNDIUsageException("getConnection: Failed to get connection: sql Exception:", sqle);
        }
        return conn;
    }

    private static DataSource getCachedDataSource(Context ctx, String pDatasourceName) {
        if (mDataSources.containsKey(pDatasourceName)) {
            return mDataSources.get(pDatasourceName);
        }
        DataSource ds = null;
        try {
            ds = (DataSource)ctx.lookup(pDatasourceName);
            mDataSources.put(pDatasourceName, ds);
            return ds;
        }
        catch (NamingException ne) {
            throw new JNDIUsageException("The Data source:" + pDatasourceName + " could not be found ", ne);
        }
    }

    private static Context getCachedInitialContext(String pUrl) {
        String url = pUrl;
        if (url == null || url.trim().length() == 0) {
            url = DEFAULT_IP;
        }
        if (mInitialContexts.containsKey(url)) {
            return mInitialContexts.get(url);
        }
        return JNDIUsage.getInitialContextAddToCache(url);
    }

    private static InitialContext getInitialContextAddToCache(String pUrl) {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", JNDI_FACTORY);
        InitialContext iCtx = null;
        try {
            if (!pUrl.equals(DEFAULT_IP)) {
                env.put("java.naming.provider.url", pUrl);
                iCtx = new InitialContext(env);
                mInitialContexts.put(pUrl, iCtx);
                return iCtx;
            }
            iCtx = new InitialContext();
            mInitialContexts.put(pUrl, iCtx);
            return iCtx;
        }
        catch (NamingException e) {
            throw new JNDIUsageException("getInitialContextIntoCache: Failed to get context", e);
        }
    }

    public static Object lookup(Context ctx, String name) {
        Object h = null;
        try {
            h = ctx.lookup(name);
        }
        catch (NamingException e) {
            throw new JNDIUsageException(name + "Could not lookup:" + name, e);
        }
        return h;
    }
}

