/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils;

import ir.middleware.Common.MWContextManager;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import uk.gov.hmrc.chris.SystemException;
import uk.gov.hmrc.chris.UtilitiesException;

public class KeyGenerator {
    public static String getKey() {
        String correlationID = null;
        MWContextManager myMWContextManager = MWContextManager.getInstance();
        try {
            myMWContextManager.setMWContext("ChRIS");
            correlationID = myMWContextManager.getMWContext().generateCorrelationID();
        }
        catch (Exception e) {
            throw new SystemException("Could not generate the correlation id from Middleware", e);
        }
        finally {
            myMWContextManager.freeMWContext();
        }
        return correlationID;
    }

    public static String getCorrelationID() throws UtilitiesException {
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new UtilitiesException("Could not instantiate the MD5 digest object", e);
        }
        md5.update(KeyGenerator.getKey().substring(0, 32).getBytes());
        byte[] key = md5.digest();
        StringBuffer sb = new StringBuffer();
        for (int j = 0; j < key.length; ++j) {
            int b = key[j] & 0xFF;
            if (b < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(b));
        }
        return sb.toString().toUpperCase();
    }
}

