/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.config;

import hmrc.middleware.config.accessor.Factory;
import hmrc.middleware.config.accessor.XMLDataItem;
import uk.gov.hmrc.chris.utils.config.ChRISConfigException;
import uk.gov.hmrc.chris.utils.config.ChRISNode;

public class ChRISConfig {
    public static ChRISNode getNode(String namespace) {
        XMLDataItem[] namespaces = null;
        try {
            namespaces = Factory.getNamespace(namespace);
            if (namespaces.length == 1) {
                ChRISNode node = new ChRISNode(namespace, namespaces[0], "<" + namespace + ">");
                return node;
            }
            if (namespaces.length > 1) {
                throw new ChRISConfigException("More than one namespace was returned for: " + namespace);
            }
            return null;
        }
        catch (Exception e) {
            throw new ChRISConfigException("ChRISConfig.getNode - Problem using Utilities config mechanism.", e);
        }
    }

    public static ChRISNode[] getNodes(String namespace) {
        XMLDataItem[] namespaces = null;
        try {
            namespaces = Factory.getNamespace(namespace);
            ChRISNode[] nodes = new ChRISNode[namespaces.length];
            for (int x = 0; x < namespaces.length; ++x) {
                nodes[x] = new ChRISNode(namespace, namespaces[x], "<" + namespace + ">");
            }
            return nodes;
        }
        catch (Exception e) {
            throw new ChRISConfigException("ChRISConfig.getNodes - Problem using Utilities config mechanism.", e);
        }
    }
}

