/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.config;

import hmrc.middleware.config.accessor.XMLDataItem;
import uk.gov.hmrc.chris.ChRISExceptionLogger;
import uk.gov.hmrc.chris.utils.config.ChRISConfigException;
import uk.gov.hmrc.chris.utils.resoucehandler.ResourceForman;
import uk.gov.hmrc.chris.utils.resoucehandler.ResourceHandler;
import uk.gov.hmrc.chris.utils.resoucehandler.ResourceHandlerException;

public class ChRISNode
implements ResourceHandler {
    private String namespace;
    private XMLDataItem configDataItem;
    private String searchCriteria;

    ChRISNode(String namespace, XMLDataItem configDataItem, String searchCriteria) {
        ResourceForman.getInstance().addLongTermResourceHandler(this);
        this.namespace = namespace;
        this.configDataItem = configDataItem;
        this.searchCriteria = searchCriteria;
    }

    public ChRISNode getNamespace(String namespace) {
        try {
            XMLDataItem[] namespaces = this.configDataItem.getNamespace(namespace);
            if (namespaces.length == 1) {
                String searchCriteria = this.searchCriteria + "/" + "<" + namespace + ">";
                ChRISNode node = new ChRISNode(namespace, namespaces[0], searchCriteria);
                return node;
            }
            if (namespaces.length > 1) {
                throw new ChRISConfigException("More than one namespace was returned for: " + namespace);
            }
            return null;
        }
        catch (Exception e) {
            throw new ChRISConfigException("ChRISNode.getNamespace - Problem using Middleware config.", e);
        }
    }

    public ChRISNode[] getNamespaces(String namespace) {
        try {
            XMLDataItem[] namespaces = this.configDataItem.getNamespace(namespace);
            ChRISNode[] nodes = new ChRISNode[namespaces.length];
            for (int i = 0; i < namespaces.length; ++i) {
                String searchCriteria = this.searchCriteria + "/" + "<" + namespace + ">";
                nodes[i] = new ChRISNode(namespace, namespaces[i], searchCriteria);
            }
            return nodes;
        }
        catch (Exception e) {
            throw new ChRISConfigException("ChRISNode.getNamespace - Problem using Middleware config.", e);
        }
    }

    private String buildXPathSearch(String xpath) {
        StringBuffer query = new StringBuffer();
        query.append("declare namespace ns='").append(this.namespace).append("'").append(";.");
        int attributeIndex = xpath.indexOf("[");
        String[] xpathElements = attributeIndex == -1 ? xpath.split("/") : xpath.substring(0, attributeIndex).split("/");
        for (int x = 0; x < xpathElements.length; ++x) {
            query.append("/ns:").append(xpathElements[x]);
        }
        if (attributeIndex > -1) {
            query.append(xpath.substring(attributeIndex));
        }
        ChRISExceptionLogger.debug(query.toString());
        return query.toString();
    }

    public ChRISNode getXPath(String XPath2) {
        try {
            String xpathSearch = this.buildXPathSearch(XPath2);
            if (xpathSearch == null) {
                throw new ChRISConfigException("The search xpath was null for XPath: " + XPath2);
            }
            XMLDataItem[] configNode = this.configDataItem.getXPath(xpathSearch);
            if (configNode == null) {
                throw new ChRISConfigException("The middleware config returned node is null for XPath: " + XPath2);
            }
            if (configNode.length > 1) {
                throw new ChRISConfigException("More than one xpath was returned.  Can only return onexpath is: " + XPath2);
            }
            if (configNode.length == 1) {
                String searchCriteria = this.searchCriteria + "/" + XPath2;
                ChRISNode node = new ChRISNode(this.namespace, configNode[0], searchCriteria);
                return node;
            }
            return null;
        }
        catch (Exception e) {
            throw new ChRISConfigException("ChRISNode.getXPath - Problem using Middleware config searching for Xpath: " + XPath2, e);
        }
    }

    public ChRISNode[] getXPaths(String XPath2) {
        try {
            String xpathSearch = this.buildXPathSearch(XPath2);
            if (xpathSearch == null) {
                throw new ChRISConfigException("The search xpath was null for XPath: " + XPath2);
            }
            XMLDataItem[] configNode = this.configDataItem.getXPath(xpathSearch);
            ChRISNode[] nodes = new ChRISNode[configNode.length];
            for (int i = 0; i < configNode.length; ++i) {
                String searchCriteria = this.searchCriteria + "/" + XPath2;
                nodes[i] = new ChRISNode(this.namespace, configNode[i], searchCriteria);
            }
            return nodes;
        }
        catch (Exception e) {
            throw new ChRISConfigException("ChRISNode.getXPaths - Problem using Middleware config searching for Xpath: " + XPath2, e);
        }
    }

    public String getValue() {
        if (this.configDataItem != null) {
            return this.configDataItem.getValue();
        }
        return null;
    }

    public String toString() {
        return "Search criteria is: " + this.searchCriteria;
    }

    public String getXmlText() {
        return this.configDataItem.getXMLData();
    }

    public String getAttributeValue(String attributeKey) {
        try {
            XMLDataItem[] attributes = this.configDataItem.getXPath("@" + attributeKey);
            if (attributes == null || attributes.length == 0 || attributes[0] == null) {
                return null;
            }
            return attributes[0].getValue();
        }
        catch (Exception e) {
            throw new ChRISConfigException("ChRISNode.getAttributeValue - Problem using Middleware config.", e);
        }
    }

    @Override
    public void releaseResources() throws ResourceHandlerException {
        this.configDataItem.releaseResources();
        this.configDataItem = null;
    }
}

