/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.config;

import uk.gov.hmrc.chris.utils.config.ChRISNode;
import uk.gov.hmrc.chris.utils.config.ConfigItemNotSetException;

public class ConfigUtils {
    public static ChRISNode validate(ChRISNode rootNode, String searchString) {
        if (rootNode == null) {
            throw new ConfigItemNotSetException("The config you are trying run search on is null");
        }
        ChRISNode node = rootNode.getXPath(searchString);
        if (node == null) {
            throw new ConfigItemNotSetException("The config you are searching for is null and the search string is : " + searchString);
        }
        return node;
    }

    public static ChRISNode[] validateConfig(ChRISNode rootNode, String searchString) {
        if (rootNode == null) {
            throw new ConfigItemNotSetException("The config you are trying run search on is null");
        }
        ChRISNode[] node = rootNode.getXPaths(searchString);
        if (node == null) {
            throw new ConfigItemNotSetException("The config you are searching for is null and the search string is : " + searchString);
        }
        return node;
    }

    public static String validateAndGetAttribute(ChRISNode rootNode, String searchString) {
        if (rootNode == null) {
            throw new ConfigItemNotSetException("The config you are trying run search on is null");
        }
        String attribValue = rootNode.getAttributeValue(searchString);
        if (attribValue == null) {
            throw new ConfigItemNotSetException("The attribute value your are looking for is null and the search string is : " + searchString);
        }
        return attribValue;
    }

    public static String getValue(ChRISNode node) {
        return node != null ? node.getValue() : null;
    }
}

