/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.connector.messagecontext;

import uk.gov.hmrc.chris.utils.ThreadLocalProxy;
import uk.gov.hmrc.chris.utils.connector.messagecontext.IMessageContext;

public class MessageContextUtil {
    private static final String THREAD_LOCAL_KEY = "MESSAGE_CONTEXT_UTIL";

    public void init(IMessageContext messageContext) {
        ThreadLocalProxy.setThreadLocalObject(THREAD_LOCAL_KEY, messageContext);
    }

    public void close() {
        ThreadLocalProxy.setThreadLocalObject(THREAD_LOCAL_KEY, null);
    }

    public static IMessageContext getMessageContext() {
        return (IMessageContext)ThreadLocalProxy.getThreadLocalObject(THREAD_LOCAL_KEY);
    }

    public static String getConversationId() {
        IMessageContext messageContext = MessageContextUtil.getMessageContext();
        if (messageContext == null || messageContext.getConversationId() == null) {
            return "UNKNOWN_CONV_ID";
        }
        return messageContext.getConversationId();
    }
}

