/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.controldocument;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import uk.gov.hmrc.chRIS.service.control.ControlDocumentDocument1;
import uk.gov.hmrc.chRIS.service.control.header.HeaderDocument;
import uk.gov.hmrc.chRIS.service.control.metaData.MetaDataDocument;
import uk.gov.hmrc.chRIS.service.payload.PayloadDocument;
import uk.gov.hmrc.chRIS.service.request.responseRoute.ResponseRouteDocument;
import uk.gov.hmrc.chris.utils.controldocument.ProcessorException;

public class Processor {
    protected static final String NAMESPACE_REQUEST_CONTROL_DOC = "http://www.hmrc.gov.uk/ChRIS/Service/Control";
    protected static final String NAMESPACE_REQUEST_RESPONSE_ROUTE = "http://www.hmrc.gov.uk/ChRIS/Service/Request/ResponseRoute";
    protected static final String NAMESPACE_REQUEST_HEADER = "http://www.hmrc.gov.uk/ChRIS/Service/Control/Header";
    protected static final String NAMESPACE_SERVICE_PAYLOAD = "http://www.hmrc.gov.uk/ChRIS/Service/Payload";
    protected static final String NAMESPACE_REQUEST_META_DATA = "http://www.hmrc.gov.uk/ChRIS/Service/Control/MetaData";
    protected ControlDocumentDocument1 controlDocumentDocument1;

    protected XmlObject xpathSearch(String xpath, XmlObject xmlBean) {
        XmlObject xmlObject = null;
        XmlObject[] xmlObjectArray = xmlBean.selectPath(xpath);
        if (xmlObjectArray != null && xmlObjectArray.length > 0) {
            xmlObject = xmlObjectArray[0];
        }
        return xmlObject;
    }

    protected XmlObject namespaceSearch(String namespace, XmlObject xmlBean) {
        XmlObject xmlObject = null;
        String xPath = "declare namespace abc='" + namespace + "';./abc:*";
        XmlObject[] xmlObjectArray = xmlBean.selectPath(xPath);
        if (xmlObjectArray != null && xmlObjectArray.length > 0) {
            xmlObject = xmlObjectArray[0];
        }
        return xmlObject;
    }

    public ControlDocumentDocument1.ControlDocument getControlDocument(InputStream xmlStream) throws ProcessorException {
        ControlDocumentDocument1.ControlDocument controlDocument = null;
        try {
            this.controlDocumentDocument1 = ControlDocumentDocument1.Factory.parse((InputStream)xmlStream);
            controlDocument = this.controlDocumentDocument1.getControlDocument();
        }
        catch (XmlException e) {
            throw new ProcessorException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ProcessorException(e.getMessage(), e);
        }
        return controlDocument;
    }

    public HeaderDocument.Header getHeader(XmlObject xmlObject) {
        HeaderDocument headerDocument = HeaderDocument.Factory.newInstance();
        HeaderDocument.Header header = headerDocument.addNewHeader();
        String xPath = "declare namespace abc='http://www.hmrc.gov.uk/ChRIS/Service/Control/Header';./abc:Header";
        header.set(xmlObject.selectPath(xPath)[0]);
        return header;
    }

    public MetaDataDocument.MetaData getMetaData(XmlObject xmlObject) {
        MetaDataDocument.MetaData metaData = null;
        MetaDataDocument metaDataDocument = MetaDataDocument.Factory.newInstance();
        metaData = metaDataDocument.addNewMetaData();
        String xPath = "declare namespace abc='http://www.hmrc.gov.uk/ChRIS/Service/Control/MetaData';./abc:MetaData";
        metaData.set(xmlObject.selectPath(xPath)[0]);
        return metaData;
    }

    public ResponseRouteDocument.ResponseRoute getResponseRoute(XmlObject xmlObject) {
        ResponseRouteDocument responderDocument = ResponseRouteDocument.Factory.newInstance();
        ResponseRouteDocument.ResponseRoute responseRoute = null;
        String xPath = "declare namespace reqresp='http://www.hmrc.gov.uk/ChRIS/Service/Request/ResponseRoute';$this//reqresp:ResponseRoute";
        XmlObject[] route = xmlObject.selectPath(xPath);
        if (route != null && route.length == 1) {
            responseRoute = responderDocument.addNewResponseRoute();
            responseRoute.set(route[0]);
        }
        return responseRoute;
    }

    public PayloadDocument.Payload getPayload(XmlObject xmlObject) {
        String xPath = "declare namespace abc='http://www.hmrc.gov.uk/ChRIS/Service/Payload';$this//abc:Payload/abc:Data";
        PayloadDocument.Payload payload = PayloadDocument.Payload.Factory.newInstance();
        payload.set(xmlObject.selectPath(xPath)[0]);
        return payload;
    }

    public InputStream getNewInputStream() throws ProcessorException {
        if (this.controlDocumentDocument1 == null) {
            throw new ProcessorException("Control document has not been parsed");
        }
        return this.controlDocumentDocument1.newInputStream();
    }

    public void setRequestId(String requestID) {
        XmlObject[] headerelements = this.controlDocumentDocument1.selectPath("declare namespace abc='http://www.hmrc.gov.uk/ChRIS/Service/Control/Header';//abc:Header");
        if (headerelements.length > 0) {
            XmlCursor headerCursor = headerelements[0].newCursor();
            headerCursor.toEndToken();
            QName qname = new QName(NAMESPACE_REQUEST_HEADER, "RequestID");
            headerCursor.insertElementWithText(qname, requestID);
        }
    }

    public void updateControlDocWithModifiedSection(ControlDocumentDocument1.ControlDocument controlDocument, XmlObject modifiedSection, String xPath) {
        XmlObject[] currentElements = controlDocument.selectPath(xPath);
        if (currentElements.length > 0) {
            XmlCursor currentElementsCursor = currentElements[0].newCursor();
            currentElementsCursor.removeXml();
            modifiedSection.newCursor().copyXml(currentElementsCursor);
        }
    }
}

