/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.decompression;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import uk.gov.hmrc.chris.utils.decompression.InflaterOutputStream;
import uk.gov.hmrc.chris.utils.decompression.InvalidCompressedFormatException;

public class GZipOutputStream
extends InflaterOutputStream {
    public static final int GZIP_MAGIC = 35615;
    final int FTEXT = 1;
    final int FHCRC = 2;
    final int FEXTRA = 4;
    final int FNAME = 8;
    final int FCOMMENT = 16;
    protected boolean multiMemberDetected = false;

    public GZipOutputStream(OutputStream out) {
        super(out);
    }

    public GZipOutputStream(OutputStream out, int bufSize) {
        super(out, bufSize);
    }

    @Override
    protected boolean consumeTrailer(ByteBuffer buffy, Checksum csum, long totalOutput, long totalInput) throws IOException {
        try {
            if (GZipOutputStream.readUInt(buffy, null) != csum.getValue() || GZipOutputStream.readUInt(buffy, null) != totalOutput) {
                throw new InvalidCompressedFormatException("Corrupt GZIP trailer");
            }
        }
        catch (BufferUnderflowException bue) {
            return false;
        }
        return true;
    }

    @Override
    protected boolean consumeHeader(ByteBuffer buf) throws IOException {
        CRC32 csum = new CRC32();
        try {
            if (GZipOutputStream.readUShort(buf, csum) != 35615) {
                throw new InvalidCompressedFormatException("Not in GZIP format");
            }
            if (GZipOutputStream.readUByte(buf, csum) != 8) {
                throw new InvalidCompressedFormatException("Unsupported compression method");
            }
            int flg = GZipOutputStream.readUByte(buf, csum);
            GZipOutputStream.skipBytes(buf, 6, csum);
            if ((flg & 4) == 4) {
                GZipOutputStream.skipBytes(buf, GZipOutputStream.readUShort(buf, csum), csum);
            }
            if ((flg & 8) == 8) {
                while (GZipOutputStream.readUByte(buf, csum) != 0) {
                }
            }
            if ((flg & 0x10) == 16) {
                while (GZipOutputStream.readUByte(buf, csum) != 0) {
                }
            }
            if ((flg & 2) == 2) {
                int v = (int)csum.getValue() & 0xFFFF;
                if (GZipOutputStream.readUShort(buf, csum) != v) {
                    throw new InvalidCompressedFormatException("Corrupt GZIP header");
                }
            }
        }
        catch (BufferUnderflowException bue) {
            return false;
        }
        return true;
    }
}

