/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.decompression;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.Checksum;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public abstract class InflaterOutputStream
extends FilterOutputStream {
    protected ByteBuffer cumulativeBuffer = null;
    protected boolean finishedHeader = false;
    protected boolean finishedBody = false;
    protected boolean finishedTrailer = false;
    protected Inflater inflater = null;
    protected Checksum bodyChecksum = ((CheckedOutputStream)this.out).getChecksum();
    protected int decompressionBufferSize = 0;

    public InflaterOutputStream(OutputStream out) {
        this(out, 4096);
    }

    public InflaterOutputStream(OutputStream out, int bufSize) {
        super(new CheckedOutputStream(out, new CRC32()));
        this.inflater = new Inflater(true);
        this.decompressionBufferSize = bufSize;
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException("The input buffer was null");
        }
        if ((off | len | b.length - (len + off) | off + len) < 0) {
            throw new IndexOutOfBoundsException();
        }
        byte[] bytesCopy = new byte[len - off];
        System.arraycopy(b, off, bytesCopy, 0, len);
        if (this.cumulativeBuffer != null && this.cumulativeBuffer.limit() != this.cumulativeBuffer.capacity()) {
            this.cumulativeBuffer.position(this.cumulativeBuffer.limit());
            this.cumulativeBuffer.limit(this.cumulativeBuffer.capacity());
        }
        this.cumulativeBuffer = InflaterOutputStream.append(this.cumulativeBuffer, bytesCopy, off, len);
        this.cumulativeBuffer.flip();
        this.doWrite();
    }

    protected void doWrite() throws IOException {
        if (this.cumulativeBuffer.hasRemaining()) {
            if (!this.finishedHeader) {
                this.finishedHeader = this.header();
                if (this.finishedHeader) {
                    this.doWrite();
                }
            } else if (!this.finishedBody) {
                this.finishedBody = this.body();
                if (this.finishedBody) {
                    this.doWrite();
                }
            } else if (!this.finishedTrailer) {
                this.finishedTrailer = this.trailer();
                if (this.finishedTrailer) {
                    this.endOfCompressedMember();
                    this.doWrite();
                }
            } else {
                throw new IOException("InflaterOutputStream has entered an invalid state, whereby neither the header, body or trailer of the compressed data is being processed.");
            }
        }
    }

    protected boolean header() throws IOException {
        this.cumulativeBuffer.mark();
        if (this.consumeHeader(this.cumulativeBuffer)) {
            this.cumulativeBuffer.compact();
            this.cumulativeBuffer.flip();
            return true;
        }
        this.cumulativeBuffer.reset();
        return false;
    }

    protected boolean body() throws IOException {
        byte[] compressedBytes = this.cumulativeBuffer.array();
        byte[] decompressedBytes = new byte[this.decompressionBufferSize];
        this.inflater.setInput(compressedBytes, 0, this.cumulativeBuffer.remaining());
        int decompressedByteCount = 0;
        try {
            int loopCount = 0;
            do {
                if ((decompressedByteCount = this.inflater.inflate(decompressedBytes)) <= 0) continue;
                this.out.write(decompressedBytes, 0, decompressedByteCount);
            } while (!this.inflater.needsInput() && !this.inflater.finished() && ++loopCount < 1000000);
            if (loopCount >= 1000000) {
                throw new IOException("Probable infinite loop detected while inflating data. (One million iterations hit)");
            }
        }
        catch (DataFormatException dfe) {
            throw new IOException("The data being decompressed was invalid.");
        }
        int startingByteCount = this.cumulativeBuffer.remaining();
        int remainingByteCount = this.inflater.getRemaining();
        int remainingBytesIndex = startingByteCount - remainingByteCount;
        this.cumulativeBuffer.position(remainingBytesIndex);
        this.cumulativeBuffer.compact();
        this.cumulativeBuffer.flip();
        if (!this.cumulativeBuffer.hasRemaining()) {
            this.cumulativeBuffer.clear();
        }
        return this.inflater.finished();
    }

    protected boolean trailer() throws IOException {
        this.cumulativeBuffer.mark();
        if (this.consumeTrailer(this.cumulativeBuffer, this.bodyChecksum, this.inflater.getBytesWritten(), this.inflater.getBytesRead())) {
            this.cumulativeBuffer.compact();
            this.cumulativeBuffer.flip();
            return true;
        }
        this.cumulativeBuffer.reset();
        return false;
    }

    protected void endOfCompressedMember() {
        this.inflater.reset();
        this.bodyChecksum.reset();
        this.finishedTrailer = false;
        this.finishedBody = false;
        this.finishedHeader = false;
    }

    protected static long readUInt(ByteBuffer buf, Checksum csum) {
        long s = InflaterOutputStream.readUShort(buf, csum);
        return (long)InflaterOutputStream.readUShort(buf, csum) << 16 | s;
    }

    protected static int readUShort(ByteBuffer buf, Checksum csum) {
        int b = InflaterOutputStream.readUByte(buf, csum);
        return InflaterOutputStream.readUByte(buf, csum) << 8 | b;
    }

    protected static int readUByte(ByteBuffer buf, Checksum csum) {
        int i = buf.get() & 0xFF;
        if (csum != null) {
            csum.update(i);
        }
        return i;
    }

    protected static void skipBytes(ByteBuffer buf, int n, Checksum csum) {
        for (int i = 0; i < n; ++i) {
            InflaterOutputStream.readUByte(buf, csum);
        }
    }

    public static ByteBuffer append(ByteBuffer buf, byte[] b, int off, int len) {
        if (buf == null) {
            ByteBuffer buffer = ByteBuffer.wrap(b, off, len).compact();
            return buffer;
        }
        if (len > buf.remaining()) {
            buf.flip();
            ByteBuffer buf2 = ByteBuffer.allocate(buf.remaining() + len);
            buf2.put(buf);
            buf2.put(b, off, len);
            return buf2;
        }
        buf.put(b, off, len);
        return buf;
    }

    protected abstract boolean consumeHeader(ByteBuffer var1) throws IOException;

    protected abstract boolean consumeTrailer(ByteBuffer var1, Checksum var2, long var3, long var5) throws IOException;
}

