/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.decompression;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class ZLibOutputStream
extends OutputStream {
    Inflater i = new Inflater();
    OutputStream out = null;

    public ZLibOutputStream(OutputStream os) {
        this.out = os;
    }

    public ZLibOutputStream(OutputStream out, int bufSize) {
        this(out);
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b});
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.i.setInput(b, off, len);
        byte[] data = new byte[32];
        try {
            int read;
            do {
                read = this.i.inflate(data);
                this.out.write(data, 0, read);
            } while (read > 0);
        }
        catch (DataFormatException e) {
            throw new IOException("Invalid data format " + e.getMessage());
        }
    }

    @Override
    public void flush() throws IOException {
        int left = this.i.getRemaining();
        byte[] dataLeft = new byte[left];
        try {
            this.i.inflate(dataLeft);
        }
        catch (DataFormatException de) {
            throw new IOException("Invalid data format " + de.getMessage());
        }
        this.out.write(dataLeft);
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

