/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.decompression;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.zip.Checksum;
import uk.gov.hmrc.chris.utils.decompression.InflaterOutputStream;
import uk.gov.hmrc.chris.utils.decompression.InvalidCompressedFormatException;
import uk.gov.hmrc.chris.utils.decompression.ZipHeaderBean;

public class ZipOutputStream
extends InflaterOutputStream {
    static final long LOCSIG = 67324752L;
    static final long EXTSIG = 134695760L;
    static final long CENSIG = 33639248L;
    static final long ENDSIG = 101010256L;
    static final int LOCHDR = 30;
    static final int EXTHDR = 16;
    static final int CENHDR = 46;
    static final int ENDHDR = 22;
    static final int LOCVER = 4;
    static final int LOCFLG = 6;
    static final int LOCHOW = 8;
    static final int LOCTIM = 10;
    static final int LOCCRC = 14;
    static final int LOCSIZ = 18;
    static final int LOCLEN = 22;
    static final int LOCNAM = 26;
    static final int LOCEXT = 28;
    static final int EXTCRC = 4;
    static final int EXTSIZ = 8;
    static final int EXTLEN = 12;
    static final int CENVEM = 4;
    static final int CENVER = 6;
    static final int CENFLG = 8;
    static final int CENHOW = 10;
    static final int CENTIM = 12;
    static final int CENCRC = 16;
    static final int CENSIZ = 20;
    static final int CENLEN = 24;
    static final int CENNAM = 28;
    static final int CENEXT = 30;
    static final int CENCOM = 32;
    static final int CENDSK = 34;
    static final int CENATT = 36;
    static final int CENATX = 38;
    static final int CENOFF = 42;
    static final int CENFIL = 46;
    static final int ENDSUB = 8;
    static final int ENDTOT = 10;
    static final int ENDSIZ = 12;
    static final int ENDOFF = 16;
    static final int ENDCOM = 20;
    static final int ENDCMT = 22;
    private ZipHeaderBean mHeader = null;
    private final byte[] tmpbuf = new byte[512];
    private byte[] b = new byte[256];
    private static final int DEFLATED = 8;
    protected boolean multiMemberDetected = false;

    public ZipOutputStream(OutputStream out) {
        super(out);
    }

    public ZipOutputStream(OutputStream out, int bufSize) {
        super(out, bufSize);
    }

    @Override
    protected boolean consumeTrailer(ByteBuffer buffy, Checksum csum, long totalOut, long totalIn) throws InvalidCompressedFormatException {
        boolean endOfTrailerReached = false;
        try {
            if ((this.mHeader.flag & 8) == 8) {
                this.read(buffy, this.tmpbuf, 0, 16);
                long sig = ZipOutputStream.get32(this.tmpbuf, 0);
                if (sig != 134695760L) {
                    throw new InvalidCompressedFormatException("error in zip trailer: invalid EXT descriptor signature");
                }
                this.mHeader.crc = ZipOutputStream.get32(this.tmpbuf, 4);
                this.mHeader.csize = ZipOutputStream.get32(this.tmpbuf, 8);
                this.mHeader.size = ZipOutputStream.get32(this.tmpbuf, 12);
            }
            if (this.mHeader.size != totalOut) {
                throw new InvalidCompressedFormatException("error in zip trailer: invalid entry size (expected " + this.mHeader.size + " but got " + totalOut + " bytes)");
            }
            if (this.mHeader.csize != totalIn) {
                throw new InvalidCompressedFormatException("error in zip trailer: invalid entry compressed size (expected " + this.mHeader.csize + " but got " + totalIn + " bytes)");
            }
            if (this.mHeader.crc != csum.getValue()) {
                throw new InvalidCompressedFormatException("error in zip trailer: invalid entry CRC (expected 0x" + Long.toHexString(this.mHeader.crc) + " but got 0x" + Long.toHexString(csum.getValue()) + ")");
            }
            if (ZipOutputStream.isCentralDirectory(buffy)) {
                this.skipCentralDirectory(buffy);
                ZipOutputStream.scanForEndOfCentralDirectory(buffy);
                this.skipEndOfCentralDirectory(buffy);
            } else if (!ZipOutputStream.isLocalHeader(buffy)) {
                throw new InvalidCompressedFormatException("Failed to process trailer. Neither 'Local Header' or 'Central Directory' found.");
            }
            endOfTrailerReached = true;
        }
        catch (IllegalArgumentException iae) {
            throw new InvalidCompressedFormatException("Failed to read trailer", iae);
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            endOfTrailerReached = false;
        }
        catch (BufferUnderflowException bue) {
            endOfTrailerReached = false;
        }
        return endOfTrailerReached;
    }

    protected static void scanForEndOfCentralDirectory(ByteBuffer buffer) {
        while (!ZipOutputStream.isEndOfCentralDirectory(buffer)) {
            buffer.get();
        }
    }

    protected void skipCentralDirectory(ByteBuffer buffer) {
        ZipOutputStream.skipBytes(buffer, 28, null);
        int filenameLength = ZipOutputStream.get16(buffer);
        int extraFieldLength = ZipOutputStream.get16(buffer);
        int fileCommentLength = ZipOutputStream.get16(buffer);
        int totalBytesRemaining = 46 + filenameLength + extraFieldLength + fileCommentLength - 28 - 6;
        ZipOutputStream.skipBytes(buffer, totalBytesRemaining, null);
    }

    protected void skipEndOfCentralDirectory(ByteBuffer buffer) {
        ZipOutputStream.skipBytes(buffer, 20, null);
        int zipFileCommentLength = ZipOutputStream.get16(buffer);
        int totalBytesRemaining = 22 + zipFileCommentLength - 20 - 2;
        ZipOutputStream.skipBytes(buffer, totalBytesRemaining, null);
    }

    @Override
    protected boolean consumeHeader(ByteBuffer buffy) throws IOException {
        try {
            this.read(buffy, this.tmpbuf, 0, 30);
            if (ZipOutputStream.get32(this.tmpbuf, 0) != 67324752L) {
                throw new InvalidCompressedFormatException("error in zip header: Invalid LOCSIG");
            }
            int len = ZipOutputStream.get16(this.tmpbuf, 26);
            if (len == 0) {
                throw new InvalidCompressedFormatException("error in zip header: missing entry name");
            }
            int blen = this.b.length;
            if (len > blen) {
                while (len > (blen *= 2)) {
                }
                this.b = new byte[blen];
            }
            this.read(buffy, this.b, 0, len);
            this.mHeader = new ZipHeaderBean(ZipOutputStream.getUTF8String(this.b, 0, len));
            this.mHeader.version = ZipOutputStream.get16(this.tmpbuf, 4);
            this.mHeader.flag = ZipOutputStream.get16(this.tmpbuf, 6);
            if ((this.mHeader.flag & 1) == 1) {
                throw new InvalidCompressedFormatException("error in zip header: encrypted ZIP entry not supported");
            }
            this.mHeader.method = ZipOutputStream.get16(this.tmpbuf, 8);
            this.mHeader.time = ZipOutputStream.get32(this.tmpbuf, 10);
            if ((this.mHeader.flag & 8) == 8) {
                if (this.mHeader.method != 8) {
                    throw new InvalidCompressedFormatException("error in zip header: only DEFLATED entries can have EXT descriptor");
                }
            } else {
                this.mHeader.crc = ZipOutputStream.get32(this.tmpbuf, 14);
                this.mHeader.csize = ZipOutputStream.get32(this.tmpbuf, 18);
                this.mHeader.size = ZipOutputStream.get32(this.tmpbuf, 22);
            }
            if ((len = ZipOutputStream.get16(this.tmpbuf, 28)) > 0) {
                byte[] bb = new byte[len];
                this.read(buffy, bb, 0, len);
                this.mHeader.extra = bb;
            }
            if (this.mHeader.method != 8) {
                throw new InvalidCompressedFormatException("error in zip header: Only the compressed zip method is supported");
            }
        }
        catch (IllegalArgumentException iae) {
            throw new InvalidCompressedFormatException("Failed to read header", iae);
        }
        catch (BufferUnderflowException bufe) {
            return false;
        }
        return true;
    }

    protected static boolean isCentralDirectory(ByteBuffer buffer) {
        int position = buffer.arrayOffset() + buffer.position();
        long fourBytes = ZipOutputStream.get32(buffer.array(), position);
        return fourBytes == 33639248L;
    }

    protected static boolean isEndOfCentralDirectory(ByteBuffer buffer) {
        int position = buffer.arrayOffset() + buffer.position();
        long fourBytes = ZipOutputStream.get32(buffer.array(), position);
        return fourBytes == 101010256L;
    }

    protected static boolean isLocalHeader(ByteBuffer buffer) {
        int position = buffer.arrayOffset() + buffer.position();
        long fourBytes = ZipOutputStream.get32(buffer.array(), position);
        return fourBytes == 67324752L;
    }

    private static String getUTF8String(byte[] b, int off, int len) {
        int offset = off;
        int count = 0;
        int max = offset + len;
        int i = offset;
        block10: while (i < max) {
            int c = b[i++] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    continue block10;
                }
                case 12: 
                case 13: {
                    if ((b[i++] & 0xC0) != 128) {
                        throw new IllegalArgumentException();
                    }
                    ++count;
                    continue block10;
                }
                case 14: {
                    if ((b[i++] & 0xC0) != 128 || (b[i++] & 0xC0) != 128) {
                        throw new IllegalArgumentException();
                    }
                    ++count;
                    continue block10;
                }
            }
            throw new IllegalArgumentException();
        }
        if (i != max) {
            throw new IllegalArgumentException();
        }
        char[] cs = new char[count];
        i = 0;
        block11: while (offset < max) {
            int c = b[offset++] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    cs[i++] = (char)c;
                    continue block11;
                }
                case 12: 
                case 13: {
                    cs[i++] = (char)((c & 0x1F) << 6 | b[offset++] & 0x3F);
                    continue block11;
                }
                case 14: {
                    int t = (b[offset++] & 0x3F) << 6;
                    cs[i++] = (char)((c & 0xF) << 12 | t | b[offset++] & 0x3F);
                    continue block11;
                }
            }
            throw new IllegalArgumentException();
        }
        return new String(cs, 0, count);
    }

    private static final int get16(byte[] b, int off) {
        return b[off] & 0xFF | (b[off + 1] & 0xFF) << 8;
    }

    private static final int get16(ByteBuffer buffer) {
        byte b1 = (byte)ZipOutputStream.readUByte(buffer, null);
        byte b2 = (byte)ZipOutputStream.readUByte(buffer, null);
        return b1 & 0xFF | (b2 & 0xFF) << 8;
    }

    private static final long get32(byte[] b, int off) {
        return (long)ZipOutputStream.get16(b, off) | (long)ZipOutputStream.get16(b, off + 2) << 16;
    }

    private void read(ByteBuffer buffy, byte[] b, int off, int len) {
        buffy.get(b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        super.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        super.write(b, off, len);
    }
}

