/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.envelopeGenerators;

import java.util.ArrayList;
import java.util.Map;
import uk.gov.hmrc.chris.utils.envelopeGenerators.EnvelopeGenerator;
import uk.gov.hmrc.chris.utils.envelopeGenerators.EnvelopeGeneratorException;
import uk.gov.hmrc.chris.utils.xml.XMLBuilder;

public class ChRISErrorGenerator
extends EnvelopeGenerator {
    public static final String ERROR_NODE = "Error";
    public static final String RAISED_BY_NODE = "RaisedBy";
    public static final String NUMBER_NODE = "Number";
    public static final String TYPE_NODE = "Type";
    public static final String SCHEMA_ERROR_TYPE = "schema";
    public static final String LOCATION_NODE = "Location";
    public static final String TEXT_NODE = "Text";
    public static final String APPLICATION_NODE = "Application";
    public static final String APPLICATION_DEVELOPER_MESSAGE_NODE = "DeveloperMessage";
    public static final String APPLICATION_SERVICE_MESSAGE_NODE = "ServiceMessage";
    public static final String APPLICATION_SERVICE_MESSAGE_USER_TEXT_NODE = "UserText";
    public static final String APPLICATION_SERVICE_MESSAGE_USER_TEXT_CODE = "UserTextCode";
    public static final String APPLICATION_SERVICE_MESSAGE_USER_TEXT_ATTRIBUTE = "Number";
    public static final String APPLICATION_SERVICE_MESSAGE_USER_LOCATION_NODE = "UserLocation";
    public static final String ERRORDATA_NODE = "ErrorData";
    private String raisedBy;
    private int number;
    private String type;
    private ArrayList<String> text = new ArrayList();
    private ArrayList<String> location = new ArrayList();
    private String developerMessage;
    private String errorData;
    private String userText;
    private String errorCode;
    private String userLocation;

    public void setDeveloperMessage(String developerMessage) {
        this.developerMessage = developerMessage;
    }

    public ChRISErrorGenerator() {
    }

    public ChRISErrorGenerator(Map<String, String> paramMap) {
        this.setRaisedBy(paramMap.get(RAISED_BY_NODE));
        this.setNumber(Integer.parseInt(paramMap.get("Number")));
        this.setType(paramMap.get(TYPE_NODE));
        this.setLocation(paramMap.get(LOCATION_NODE));
        this.setText(paramMap.get(TEXT_NODE));
        this.setDeveloperMessage(paramMap.get(APPLICATION_DEVELOPER_MESSAGE_NODE));
        this.setUserText(paramMap.get(APPLICATION_SERVICE_MESSAGE_USER_TEXT_NODE));
        this.setErrorCode(paramMap.get(APPLICATION_SERVICE_MESSAGE_USER_TEXT_CODE));
        this.setUserLocation(paramMap.get(APPLICATION_SERVICE_MESSAGE_USER_LOCATION_NODE));
        this.setErrorData(paramMap.get(ERRORDATA_NODE));
    }

    @Override
    protected void generateContent(XMLBuilder builder) throws EnvelopeGeneratorException {
        try {
            builder.writeStartElement(ERROR_NODE);
            builder.writeSimpleElement(RAISED_BY_NODE, this.raisedBy);
            builder.writeSimpleElement("Number", this.number);
            builder.writeSimpleElement(TYPE_NODE, this.type);
            builder.writeSimpleElement(TEXT_NODE, this.text);
            builder.writeSimpleElement(LOCATION_NODE, this.location);
            if (this.errorData != null) {
                builder.writeSimpleElement(ERRORDATA_NODE, this.errorData);
            }
            if (this.userLocation != null || this.developerMessage != null || this.userText != null) {
                builder.writeStartElement(APPLICATION_NODE);
                if (this.userLocation != null || this.userText != null) {
                    builder.writeStartElement(APPLICATION_SERVICE_MESSAGE_NODE);
                    if (this.userLocation != null) {
                        builder.writeSimpleElement(APPLICATION_SERVICE_MESSAGE_USER_LOCATION_NODE, this.userLocation);
                    }
                    if (this.userText != null) {
                        builder.writeStartElement(APPLICATION_SERVICE_MESSAGE_USER_TEXT_NODE);
                        builder.writeAttribute("Number", this.errorCode);
                        builder.writeText(this.userText);
                        builder.writeEndElement();
                    }
                    builder.writeEndElement();
                }
                if (this.developerMessage != null) {
                    builder.writeSimpleElement(APPLICATION_DEVELOPER_MESSAGE_NODE, this.developerMessage);
                }
                builder.writeEndElement();
            }
            builder.writeEndElement();
        }
        catch (XMLBuilder.XMLBuilderException e) {
            throw new EnvelopeGeneratorException("Problem creating error XML document", e);
        }
    }

    public ArrayList<String> getLocation() {
        return this.location;
    }

    public String getRaisedBy() {
        return this.raisedBy;
    }

    public int getNumber() {
        return this.number;
    }

    public ArrayList<String> getText() {
        return this.text;
    }

    public String getType() {
        return this.type;
    }

    public String getErrorData() {
        return this.errorData;
    }

    public String getUserText() {
        return this.userText;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getUserLocation() {
        return this.userLocation;
    }

    public void setLocation(String location) {
        this.location.add(location);
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public void setRaisedBy(String raisedBy) {
        this.raisedBy = raisedBy;
    }

    public void setText(String text) {
        this.text.add(text);
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setErrorData(String errorData) {
        this.errorData = errorData;
    }

    public void setUserText(String userText) {
        this.userText = userText;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public void setUserLocation(String userLocation) {
        this.userLocation = userLocation;
    }

    public boolean isSchemaError() {
        return SCHEMA_ERROR_TYPE.equals(this.type);
    }
}

