/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.envelopeGenerators;

import java.util.ArrayList;
import java.util.List;
import uk.gov.hmrc.chris.utils.envelopeGenerators.ChRISErrorGenerator;
import uk.gov.hmrc.chris.utils.envelopeGenerators.EnvelopeGenerator;
import uk.gov.hmrc.chris.utils.envelopeGenerators.EnvelopeGeneratorException;
import uk.gov.hmrc.chris.utils.errors.ChRISError;
import uk.gov.hmrc.chris.utils.xml.XMLBuilder;

public class ChRISErrorsGenerator
extends EnvelopeGenerator {
    private static final String ROOT_NODE = "Errors";
    private static final String XMLNS_ATTRIBUTE = "xmlns";
    private static final String XMLNS_NAMESPACE_ATTRIBUTE = "http://www.hmrc.gov.uk/ChRIS/Errors";
    private static final String XMLNS_XSI_ATTRIBUTE = "xmlns:xsi";
    private static final String XMLNS_XSI_NAMESPACE_ATTRIBUTE = "http://www.w3.org/2001/XMLSchema-instance";
    private ArrayList<ChRISErrorGenerator> errors = new ArrayList();

    @Override
    protected void generateContent(XMLBuilder builder) throws EnvelopeGeneratorException {
        try {
            builder.writeStartElement(ROOT_NODE);
            builder.writeAttribute(XMLNS_ATTRIBUTE, XMLNS_NAMESPACE_ATTRIBUTE);
            builder.writeAttribute(XMLNS_XSI_ATTRIBUTE, XMLNS_XSI_NAMESPACE_ATTRIBUTE);
            for (int i = 0; i < this.errors.size(); ++i) {
                this.errors.get(i).generate(builder);
            }
            builder.writeEndElement();
        }
        catch (XMLBuilder.XMLBuilderException e) {
            throw new EnvelopeGeneratorException("Problem creating errors XML document", e);
        }
    }

    public void addError(ChRISErrorGenerator error) {
        this.errors.add(error);
    }

    public void addError(ChRISError error) {
        ChRISErrorGenerator errorGenerator = new ChRISErrorGenerator();
        errorGenerator.setRaisedBy(error.getRaisedBy());
        errorGenerator.setNumber(error.getNumber());
        errorGenerator.setType(error.getType());
        errorGenerator.setText(error.getText());
        errorGenerator.setLocation(error.getLocation());
        this.errors.add(errorGenerator);
    }

    public void addErrors(List<ChRISError> errors) {
        for (ChRISError error : errors) {
            this.addError(error);
        }
    }

    public int getTotalNumberOfErrors() {
        return this.errors.size();
    }
}

