/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.envelopeGenerators;

import java.util.ArrayList;
import java.util.List;
import uk.gov.hmrc.chris.utils.envelopeGenerators.EnvelopeGenerator;
import uk.gov.hmrc.chris.utils.envelopeGenerators.EnvelopeGeneratorException;
import uk.gov.hmrc.chris.utils.xml.XMLBuilder;

public class ChRISSuccessGenerator
extends EnvelopeGenerator {
    private static final String MESSAGE_NODE = "Message";
    private static final String CODE_ATTRIBUTE = "code";
    public static final String NUMBER_NODE = "Number";
    public static final String TEXT_NODE = "Text";
    private int number;
    private final List<String> text = new ArrayList<String>();

    @Override
    protected void generateContent(XMLBuilder builder) throws EnvelopeGeneratorException {
        try {
            builder.writeStartElement(MESSAGE_NODE);
            builder.writeAttribute(CODE_ATTRIBUTE, Integer.toString(this.number));
            builder.writeText(this.text.get(0));
            builder.writeEndElement();
        }
        catch (XMLBuilder.XMLBuilderException e) {
            throw new EnvelopeGeneratorException("Problem creating success XML document", e);
        }
    }

    public int getNumber() {
        return this.number;
    }

    public List<String> getText() {
        return this.text;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public void setText(String text) {
        this.text.add(text);
    }
}

