/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.envelopeGenerators;

import java.util.ArrayList;
import java.util.List;
import uk.gov.hmrc.chris.utils.envelopeGenerators.ChRISSuccessGenerator;
import uk.gov.hmrc.chris.utils.envelopeGenerators.EnvelopeGenerator;
import uk.gov.hmrc.chris.utils.envelopeGenerators.EnvelopeGeneratorException;
import uk.gov.hmrc.chris.utils.success.ChRISSuccess;
import uk.gov.hmrc.chris.utils.xml.XMLBuilder;

public class ChRISSuccessesGenerator
extends EnvelopeGenerator {
    private static final String ROOT_NODE = "Success";
    private static final String XMLNS_ATTRIBUTE = "xmlns";
    private static final String XMLNS_NAMESPACE_ATTRIBUTE = "http://www.hmrc.gov.uk/ChRIS/Success";
    private static final String XMLNS_XSI_ATTRIBUTE = "xmlns:xsi";
    private static final String XMLNS_XSI_NAMESPACE_ATTRIBUTE = "http://www.w3.org/2001/XMLSchema-instance";
    private final List<ChRISSuccessGenerator> successes = new ArrayList<ChRISSuccessGenerator>();

    @Override
    protected void generateContent(XMLBuilder builder) throws EnvelopeGeneratorException {
        try {
            builder.writeStartElement(ROOT_NODE);
            builder.writeAttribute(XMLNS_ATTRIBUTE, XMLNS_NAMESPACE_ATTRIBUTE);
            builder.writeAttribute(XMLNS_XSI_ATTRIBUTE, XMLNS_XSI_NAMESPACE_ATTRIBUTE);
            for (int i = 0; i < this.successes.size(); ++i) {
                this.successes.get(i).generate(builder);
            }
            builder.writeEndElement();
        }
        catch (XMLBuilder.XMLBuilderException e) {
            throw new EnvelopeGeneratorException("Problem creating successes XML document", e);
        }
    }

    public void addSuccess(ChRISSuccessGenerator success) {
        this.successes.add(success);
    }

    public void addSuccess(ChRISSuccess success) {
        ChRISSuccessGenerator successGenerator = new ChRISSuccessGenerator();
        successGenerator.setNumber(success.getNumber());
        successGenerator.setText(success.getText());
        this.successes.add(successGenerator);
    }

    public void addSuccesses(List<ChRISSuccess> successRsponses) {
        for (ChRISSuccess success : successRsponses) {
            this.addSuccess(success);
        }
    }

    public int getTotalNumberOfSuccesses() {
        return this.successes.size();
    }
}

