/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.envelopeGenerators;

import uk.gov.hmrc.chris.utils.envelopeGenerators.ContentGenerator;
import uk.gov.hmrc.chris.utils.envelopeGenerators.EnvelopeGeneratorException;
import uk.gov.hmrc.chris.utils.xml.XMLBuilder;

public abstract class EnvelopeGenerator
implements ContentGenerator {
    private boolean isExausted;
    private boolean exhaustible = true;

    public void setExhaustible(boolean exhaustible) {
        this.exhaustible = exhaustible;
    }

    protected abstract void generateContent(XMLBuilder var1) throws EnvelopeGeneratorException;

    @Override
    public void generate(XMLBuilder xmlBuilder) throws EnvelopeGeneratorException {
        if (this.isExausted && this.exhaustible) {
            throw new EnvelopeGeneratorException("Content already run.  Please examine your data flow");
        }
        this.generateContent(xmlBuilder);
        this.isExausted = true;
    }

    protected void generate(XMLBuilder builder, ContentGenerator content) throws EnvelopeGeneratorException {
        if (content != null) {
            if (content instanceof EnvelopeGenerator) {
                ((EnvelopeGenerator)content).setExhaustible(this.exhaustible);
            }
            content.generate(builder);
        }
    }
}

