/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.envelopeGenerators;

import java.util.ArrayList;
import uk.gov.hmrc.chris.utils.envelopeGenerators.EnvelopeGenerator;
import uk.gov.hmrc.chris.utils.envelopeGenerators.EnvelopeGeneratorException;
import uk.gov.hmrc.chris.utils.xml.XMLBuilder;

public class MappedErrorResponseGenerator
extends EnvelopeGenerator {
    private static final String ERROR_NODE = "Error";
    private static final String RAISED_BY_NODE = "RaisedBy";
    private static final String NUMBER_NODE = "Number";
    private static final String TYPE_NODE = "Type";
    private static final String LOCATION_NODE = "Location";
    private static final String TEXT_NODE = "Text";
    private static final String APPLICATION_NODE = "Application";
    private static final String MESSAGES_NODE = "Messages";
    private static final String SERVICEMESSAGES_NODE = "ServiceMessage";
    private static final String USERLOCATION_NODE = "UserLocation";
    private static final String USERTEXT_NODE = "UserText";
    private static final String NUMBER_ATTR = "number";
    private static final String DEVELOPERMESSAGE_NODE = "DeveloperMessage";
    private static final String XMLNS_ATTRIBUTE = "xmlns";
    private static final String MESSAGES_XMLNS_ATTRIBUTE_VALUE = "http://www.govtalk.gov.uk/validation/messages/1";
    private String raisedBy;
    private int number;
    private int mapNumber;
    private String type;
    private String mapText;
    private String mapLocation;
    private String developerMessage;
    private ArrayList<String> text = new ArrayList();
    private ArrayList<String> location = new ArrayList();

    @Override
    protected void generateContent(XMLBuilder builder) throws EnvelopeGeneratorException {
        try {
            builder.writeStartElement(ERROR_NODE);
            builder.writeSimpleElement(RAISED_BY_NODE, this.raisedBy);
            builder.writeSimpleElement(NUMBER_NODE, this.number);
            builder.writeSimpleElement(TYPE_NODE, this.type);
            builder.writeSimpleElement(TEXT_NODE, this.text);
            builder.writeSimpleElement(LOCATION_NODE, this.location);
            if (this.mapLocation != null || this.mapText != null || this.developerMessage != null) {
                builder.writeStartElement(APPLICATION_NODE);
                builder.writeStartElement(MESSAGES_NODE);
                builder.writeAttribute(XMLNS_ATTRIBUTE, MESSAGES_XMLNS_ATTRIBUTE_VALUE);
                if (this.mapLocation != null || this.mapText != null) {
                    builder.writeStartElement(SERVICEMESSAGES_NODE);
                    if (this.mapLocation != null) {
                        builder.writeSimpleElement(USERLOCATION_NODE, this.mapLocation);
                    }
                    if (this.mapText != null) {
                        builder.writeStartElement(USERTEXT_NODE);
                        builder.writeAttribute(NUMBER_ATTR, Integer.toString(this.mapNumber));
                        builder.writeText(this.mapText);
                        builder.writeEndElement();
                    }
                    builder.writeEndElement();
                }
                if (this.developerMessage != null) {
                    builder.writeSimpleElement(DEVELOPERMESSAGE_NODE, this.developerMessage);
                }
                builder.writeEndElement();
                builder.writeEndElement();
            }
            builder.writeEndElement();
        }
        catch (XMLBuilder.XMLBuilderException e) {
            throw new EnvelopeGeneratorException("Problem creating error XML document", e);
        }
    }

    public void setLocation(String location) {
        this.location.add(location);
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public void setRaisedBy(String raisedBy) {
        this.raisedBy = raisedBy;
    }

    public void setText(String text) {
        this.text.add(text);
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setMapLocation(String mapLocation) {
        this.mapLocation = mapLocation;
    }

    public void setMapNumber(int mapNumber) {
        this.mapNumber = mapNumber;
    }

    public void setMapText(String mapText) {
        this.mapText = mapText;
    }

    public void setDeveloperMessage(String developerMessage) {
        this.developerMessage = developerMessage;
    }
}

