/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.envelopeGenerators;

import uk.gov.hmrc.chris.utils.envelopeGenerators.ChRISErrorGenerator;
import uk.gov.hmrc.chris.utils.envelopeGenerators.EnvelopeGeneratorException;
import uk.gov.hmrc.chris.utils.xml.XMLBuilder;

public class SDLTErrorGenerator
extends ChRISErrorGenerator {
    public static final String APPLICATION_ELEMENT = "Application";
    public static final String SCHEDULEREFERENCE_ELEMENT = "ScheduleReference";
    public static final String SCHEDULEOCCURRENCE_ELEMENT = "ScheduleOccurrence";
    public static final String GOTOBOXNUMBER_ELEMENT = "GotoBoxNumber";
    private String scheduleReference;
    private String scheduleOccurrence;
    private String gotoBoxNumber;

    @Override
    protected void generateContent(XMLBuilder builder) throws EnvelopeGeneratorException {
        try {
            builder.writeStartElement("Error");
            builder.writeSimpleElement("RaisedBy", this.getRaisedBy());
            builder.writeSimpleElement("Number", this.getNumber());
            builder.writeSimpleElement("Type", this.getType());
            builder.writeSimpleElement("Text", this.getText());
            builder.writeSimpleElement("Location", this.getLocation());
            builder.writeSimpleElement("ErrorData", this.getErrorData());
            if (this.getScheduleReference() != null || this.getScheduleOccurrence() != null || this.getGotoBoxNumber() != null) {
                builder.writeStartElement(APPLICATION_ELEMENT);
                builder.writeSimpleElement(SCHEDULEREFERENCE_ELEMENT, this.getScheduleReference());
                builder.writeSimpleElement(SCHEDULEOCCURRENCE_ELEMENT, this.getScheduleOccurrence());
                builder.writeSimpleElement(GOTOBOXNUMBER_ELEMENT, this.getGotoBoxNumber());
                builder.writeEndElement();
            }
            builder.writeEndElement();
        }
        catch (XMLBuilder.XMLBuilderException e) {
            throw new EnvelopeGeneratorException("Problem creating error XML document", e);
        }
    }

    public String getScheduleReference() {
        return this.scheduleReference;
    }

    public void setScheduleReference(String scheduleReference) {
        this.scheduleReference = scheduleReference;
    }

    public String getScheduleOccurrence() {
        return this.scheduleOccurrence;
    }

    public void setScheduleOccurrence(String scheduleOccurrence) {
        this.scheduleOccurrence = scheduleOccurrence;
    }

    public String getGotoBoxNumber() {
        return this.gotoBoxNumber;
    }

    public void setGotoBoxNumber(String gotoBoxNumber) {
        this.gotoBoxNumber = gotoBoxNumber;
    }
}

