/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.envelopeGenerators.Tracking.errors;

import uk.gov.hmrc.chris.utils.envelopeGenerators.ContentGenerator;
import uk.gov.hmrc.chris.utils.envelopeGenerators.EnvelopeGeneratorException;
import uk.gov.hmrc.chris.utils.errors.ChRISError;
import uk.gov.hmrc.chris.utils.xml.XMLBuilder;

public class TrackingDocumentInlineErrorGenerator
implements ContentGenerator {
    private static final String ERRORS_NODE = "Errors";
    private static final String XMLNS_ATTRIBUTE = "xmlns";
    private static final String XMLNS_NAMESPACE_ATTRIBUTE = "http://www.hmrc.gov.uk/ChRIS/Errors";
    private static final String XMLNS_XSI_ATTRIBUTE = "xmlns:xsi";
    private static final String XMLNS_XSI_NAMESPACE_ATTRIBUTE = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String ERROR_NODE = "Error";
    private static final String RAISEDBY_NODE = "RaisedBy";
    private static final String NUMBER_NODE = "Number";
    private static final String TYPE_NODE = "Type";
    private static final String TEXT_NODE = "Text";
    private static final String LOCATION_NODE = "Location";
    private ChRISError[] errors;

    public void setErrors(ChRISError[] errors) {
        this.errors = errors;
    }

    @Override
    public void generate(XMLBuilder xmlBuilder) throws EnvelopeGeneratorException {
        try {
            xmlBuilder.writeStartElement(ERRORS_NODE);
            xmlBuilder.writeAttribute(XMLNS_ATTRIBUTE, XMLNS_NAMESPACE_ATTRIBUTE);
            xmlBuilder.writeAttribute(XMLNS_XSI_ATTRIBUTE, XMLNS_XSI_NAMESPACE_ATTRIBUTE);
            for (ChRISError error : this.errors) {
                xmlBuilder.writeStartElement(ERROR_NODE);
                xmlBuilder.writeSimpleElement(RAISEDBY_NODE, error.getRaisedBy());
                xmlBuilder.writeSimpleElement(NUMBER_NODE, error.getNumber());
                xmlBuilder.writeSimpleElement(TYPE_NODE, error.getType());
                xmlBuilder.writeSimpleElement(TEXT_NODE, error.getText());
                xmlBuilder.writeSimpleElement(LOCATION_NODE, error.getLocation());
                xmlBuilder.writeEndElement();
            }
            xmlBuilder.writeEndElement();
        }
        catch (XMLBuilder.XMLBuilderException e) {
            throw new EnvelopeGeneratorException("Problem using XMLBuilder", e);
        }
    }
}

