/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.envelopeGenerators.ValidationServices;

import uk.gov.hmrc.chris.utils.envelopeGenerators.ContentGenerator;
import uk.gov.hmrc.chris.utils.envelopeGenerators.EnvelopeGeneratorException;
import uk.gov.hmrc.chris.utils.xml.XMLBuilder;

public class ValidationServicesGenerator
implements ContentGenerator {
    private static final String VALIDATION_SERVICE_NODE = "ValidationServices";
    private static final String XMLNS_ATTRIBUTE = "xmlns";
    private static final String XMLNS_NAMESPACE_ATTRIBUTE = "http://www.hmrc.gov.uk/ChRIS/Service/ValidationServices";
    private static final String JDBC_NODE = "JDBC";
    private static final String DATASOURCE_NODE = "Datasource";
    private String[] dataSourceNames;
    private String qs2Status;
    private String qs3Status;

    @Override
    public void generate(XMLBuilder xmlBuilder) throws EnvelopeGeneratorException {
        try {
            xmlBuilder.writeStartElement(VALIDATION_SERVICE_NODE);
            xmlBuilder.writeAttribute(XMLNS_ATTRIBUTE, XMLNS_NAMESPACE_ATTRIBUTE);
            xmlBuilder.writeStartElement(JDBC_NODE);
            for (String dataSourceName : this.dataSourceNames) {
                xmlBuilder.writeSimpleElement(DATASOURCE_NODE, dataSourceName);
            }
            xmlBuilder.writeEndElement();
            xmlBuilder.writeEndElement();
        }
        catch (XMLBuilder.XMLBuilderException e) {
            throw new EnvelopeGeneratorException("Problem using XMLBuilder", e);
        }
    }

    public void setDataSourceNames(String[] dataSourceNames) {
        this.dataSourceNames = dataSourceNames;
    }

    public void setQs2Status(String qs2Status) {
        this.qs2Status = qs2Status;
    }

    public void setQs3Status(String qs3Status) {
        this.qs3Status = qs3Status;
    }
}

