/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.envelopeGenerators.chrisenvelope;

import java.io.ByteArrayInputStream;
import java.util.Date;
import uk.gov.hmrc.chris.utils.envelopeGenerators.ContentGenerator;
import uk.gov.hmrc.chris.utils.envelopeGenerators.EnvelopeGenerator;
import uk.gov.hmrc.chris.utils.envelopeGenerators.EnvelopeGeneratorException;
import uk.gov.hmrc.chris.utils.envelopeGenerators.chrisenvelope.Error;
import uk.gov.hmrc.chris.utils.envelopeGenerators.chrisenvelope.Function;
import uk.gov.hmrc.chris.utils.envelopeGenerators.chrisenvelope.Qualifier;
import uk.gov.hmrc.chris.utils.xml.XMLBuilder;

public class ChRISEnvelopeGeneratorV2_0
extends EnvelopeGenerator {
    private static final String ROOT_NODE = "ChRISEnvelope";
    private static final String XML_NS_ATTRIBUTE = "xmlns";
    private static final String XML_NS_ATTRIBUTE_VALUE = "http://www.hmrc.gov.uk/ChRIS/Envelope/2";
    private static final String ENVELOPE_VERSION_NODE = "EnvelopeVersion";
    private static final String HEADER_NODE = "Header";
    private static final String CORRELATING_ID_NODE = "CorrelatingID";
    private static final String RECEIPT_DATE_NODE = "ReceiptDate";
    private static final String MESSAGE_CLASS_NODE = "MessageClass";
    private static final String QULIFIER_NODE = "Qualifier";
    private static final String TRANSACTION_ID_NODE = "TransactionID";
    private static final String FUNCTION_NODE = "Function";
    private static final String SENDER_NODE = "Sender";
    private static final String SYSTEM_NODE = "System";
    private static final String SENDER_CORRELATION_ID_NODE = "CorrelatingID";
    private static final String SENDER_RECEIPT_DATE_NODE = "ReceiptDate";
    private static final String VENDOR_DETAILS_NODE = "VendorDetails";
    private static final String URI_NODE = "URI";
    private static final String NAME_NODE = "Name";
    private static final String PRODUCT_NODE = "Product";
    private static final String VERSION_NODE = "Version";
    private static final String POLLING_INTERVAL_ATTRIBUTE = "PollInterval";
    private static final String ADDITIONS_NODE = "Additions";
    private static final String RESPONSE_URL_NODE = "ResponseURL";
    private static final String RESPONSE_DETAILS_NODE = "ResponseDetails";
    private static final String ERROR_NODE = "Error";
    private static final String RAISED_BY_NODE = "RaisedBy";
    private static final String NUMBER_NODE = "Number";
    private static final String TYPE_NODE = "Type";
    private static final String TEXT_NODE = "Text";
    private static final String LOCATION_NODE = "Location";
    private static final String BODY_NODE = "Body";
    private static final String ENVELOPE_VERSION = "2.0";
    private String chrisCorrelatingID;
    private String messageClass;
    private String qualifier;
    private String transactionID;
    private String function;
    private String system;
    private String sendersCorrelatingID;
    private Date sendersReceiptDate;
    private String vendorUri;
    private String venodrName;
    private String product;
    private String productVersion;
    private String additions;
    private String responseURL;
    private String responseInterval;
    private Error error;
    private ContentGenerator body;

    @Override
    protected void generateContent(XMLBuilder builder) throws EnvelopeGeneratorException {
        this.init();
        try {
            builder.writeStartElement(ROOT_NODE);
            builder.writeAttribute(XML_NS_ATTRIBUTE, XML_NS_ATTRIBUTE_VALUE);
            builder.writeSimpleElement(ENVELOPE_VERSION_NODE, ENVELOPE_VERSION);
            builder.writeStartElement(HEADER_NODE);
            builder.writeSimpleElement("CorrelatingID", this.chrisCorrelatingID);
            builder.writeSimpleElement(MESSAGE_CLASS_NODE, this.messageClass);
            builder.writeSimpleElement(QULIFIER_NODE, this.qualifier);
            builder.writeSimpleElement(TRANSACTION_ID_NODE, this.transactionID);
            builder.writeSimpleElement(FUNCTION_NODE, this.function);
            builder.writeStartElement(SENDER_NODE);
            builder.writeSimpleElement(SYSTEM_NODE, this.system);
            builder.writeSimpleElement("CorrelatingID", this.sendersCorrelatingID);
            builder.writeSimpleTimeStampElement("ReceiptDate", this.sendersReceiptDate);
            builder.writeStartElement(VENDOR_DETAILS_NODE);
            builder.writeSimpleElement(URI_NODE, this.vendorUri);
            builder.writeSimpleElement(NAME_NODE, this.venodrName);
            builder.writeSimpleElement(PRODUCT_NODE, this.product);
            builder.writeSimpleElement(VERSION_NODE, this.productVersion);
            builder.writeEndElement();
            if (this.additions != null) {
                builder.writeStartElement(ADDITIONS_NODE);
                builder.AppendDocument(new ByteArrayInputStream(this.additions.getBytes()));
                builder.writeEndElement();
            }
            builder.writeEndElement();
            if (this.responseURL != null) {
                builder.writeStartElement(RESPONSE_URL_NODE);
                builder.addAttribute(builder, POLLING_INTERVAL_ATTRIBUTE, this.responseInterval);
                builder.writeText(this.responseURL);
                builder.writeEndElement();
            }
            builder.writeEndElement();
            if (this.error != null) {
                builder.writeStartElement(RESPONSE_DETAILS_NODE);
                builder.writeStartElement(ERROR_NODE);
                builder.writeSimpleElement(RAISED_BY_NODE, this.error.getRaisedBy());
                builder.writeSimpleElement(NUMBER_NODE, this.error.getNumber());
                builder.writeSimpleElement(TYPE_NODE, this.error.getType());
                builder.writeSimpleElement(TEXT_NODE, this.error.getText());
                builder.writeSimpleElement(LOCATION_NODE, this.error.getLocation());
                builder.writeEndElement();
                builder.writeEndElement();
            }
            builder.writeStartElement(BODY_NODE);
            this.generate(builder, this.body);
            builder.writeEndElement();
            builder.endDocument();
        }
        catch (XMLBuilder.XMLBuilderException e) {
            throw new EnvelopeGeneratorException("Exception occured while generating ChRIS Envelope", e);
        }
    }

    private void init() throws EnvelopeGeneratorException {
        StringBuffer msg = new StringBuffer();
        String nodeSeperator = "/";
        String headerNode = "ChRISEnvelope/Header/";
        String senderNode = "ChRISEnvelope/Header/Sender/";
        if (this.messageClass == null) {
            this.appendMessage(msg, "ChRISEnvelope/Header/", MESSAGE_CLASS_NODE);
        }
        if (this.qualifier == null) {
            this.appendMessage(msg, "ChRISEnvelope/Header/", QULIFIER_NODE);
        }
        if (this.function == null) {
            this.appendMessage(msg, "ChRISEnvelope/Header/", FUNCTION_NODE);
        }
        if (this.system == null) {
            this.appendMessage(msg, "ChRISEnvelope/Header/Sender/", SYSTEM_NODE);
        }
        if (this.sendersCorrelatingID == null) {
            this.appendMessage(msg, "ChRISEnvelope/Header/Sender/", "CorrelatingID");
        }
        if (this.sendersReceiptDate == null) {
            this.appendMessage(msg, "ChRISEnvelope/Header/Sender/", "ReceiptDate");
        }
        if (msg.length() != 0) {
            msg.append(" ]\n");
            throw new EnvelopeGeneratorException("Values for the following mandatory elements were not set [" + msg.toString());
        }
    }

    private void appendMessage(StringBuffer msg, String parentNode, String nodeName) {
        msg.append("\n");
        msg.append(parentNode);
        msg.append(nodeName);
    }

    public void setAdditions(String additions) {
        this.additions = additions;
    }

    public void setBody(ContentGenerator body) {
        this.body = body;
    }

    public void setCorrelatingID(String correlatingID) {
        this.chrisCorrelatingID = correlatingID;
    }

    public void setError(Error error) {
        this.error = error;
    }

    public void setFunction(Function function) {
        this.function = function.getValue();
    }

    public void setMessageClass(String messageClass) {
        this.messageClass = messageClass;
    }

    public void setProduct(String product) {
        this.product = product;
    }

    public void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }

    public void setQualifier(Qualifier qualifier) {
        this.qualifier = qualifier.getValue();
    }

    public void setReceiptDate(Date receiptDate) {
        this.sendersReceiptDate = receiptDate;
    }

    public void setResponseURL(String responseURL, String interval) {
        this.responseURL = responseURL;
        this.responseInterval = interval;
    }

    public void setSendersCorrelatingID(String sendersCorrelatingID) {
        this.sendersCorrelatingID = sendersCorrelatingID;
    }

    public void setSystem(String system) {
        this.system = system;
    }

    public void setTransactionID(String transactionID) {
        this.transactionID = transactionID;
    }

    public void setVendorUri(String vendorUri) {
        this.vendorUri = vendorUri;
    }

    public void setVenodrName(String venodrName) {
        this.venodrName = venodrName;
    }
}

