/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.envelopeGenerators.ericenvelope;

import java.util.Date;
import uk.gov.hmrc.chris.utils.envelopeGenerators.ContentGenerator;
import uk.gov.hmrc.chris.utils.envelopeGenerators.EnvelopeGenerator;
import uk.gov.hmrc.chris.utils.envelopeGenerators.EnvelopeGeneratorException;
import uk.gov.hmrc.chris.utils.envelopeGenerators.ericenvelope.Error;
import uk.gov.hmrc.chris.utils.envelopeGenerators.ericenvelope.Qualifier;
import uk.gov.hmrc.chris.utils.xml.XMLBuilder;

public class EricEnvelopeGeneratorV1_5
extends EnvelopeGenerator {
    private static final String ROOT_NODE = "EricEnvelope";
    private static final String XML_NS_ATTRIBUTE = "xmlns";
    private static final String XML_NS_ATTRIBUTE_VALUE = "http://www.inlandrevenue.gov.uk/schemas/EricEnvelope";
    private static final String HEADER_NODE = "MessageHeader";
    private static final String ENVELOPE_VERSION_NODE = "EnvelopeVersion";
    private static final String MESSAGE_CLASS_NODE = "Class";
    private static final String QUALIFIER_NODE = "Qualifier";
    private static final String FUNCTION_NODE = "Function";
    private static final String ERIC_MESSAGEID_NODE = "EricMessageID";
    private static final String ROUTING_NODE = "Routing";
    private static final String CAPTURE_METHOD_NODE = "CaptureMethod";
    private static final String SYSTEM_NODE = "System";
    private static final String RECEIPT_DATE_NODE = "ReceiptDate";
    private static final String CAPTURE_DATE_NODE = "CaptureDate";
    private static final String CAPTUREID_NODE = "CaptureID";
    private static final String MESSAGE_BODY_NODE = "MessageBody";
    private static final String ERROR_RESPONSE_NODE = "ErrorResponse";
    private static final String ERROR_NODE = "Error";
    private static final String RAISED_BY_NODE = "RaisedBy";
    private static final String NUMBER_NODE = "Number";
    private static final String TYPE_NODE = "Type";
    private static final String TEXT_NODE = "Text";
    private static final String LOCATION_NODE = "Location";
    private static final String EDI_PARTNERID_NODE = "TradingPartnerID";
    private static final String EDI_REF_NODE = "EDIRef";
    private static final String VENDOR_DETAILS_NODE = "VendorDetails";
    private static final String VENDOR_URI_NODE = "URI";
    private static final String VENDOR_NAME_NODE = "Name";
    private static final String VENDOR_PRODUCT_NODE = "Product";
    private static final String VENDOR_VERSION_NODE = "Version";
    private static final String PROFORMAFLAG_NODE = "ProFormaFlag";
    private static final String FTR_NODE = "FTR";
    private static final String CAPTURE_METHOD_EDI = "EDI";
    private static final String CAPTURE_METHOD_PAPER = "Paper";
    private static final String CAPTURE_METHOD_MAGMEDIA = "MagMedia";
    private static final String ENVELOPE_VERSION = "1.5";
    private String messageClass;
    private String qualifier;
    private String function;
    private String ericMessageId;
    private String captureMethod;
    private String system;
    private Date captureDate;
    private String captureId;
    private String tradingPartnerID;
    private String ediRef;
    private String vendorUri;
    private String vendorName;
    private String vendorProduct;
    private String vendorVersion;
    private String paperProFormaFlag;
    private String ftr;
    private Error error;
    private ContentGenerator messageBody;

    @Override
    protected void generateContent(XMLBuilder builder) throws EnvelopeGeneratorException {
        this.init();
        try {
            builder.writeStartElement(ROOT_NODE);
            builder.writeAttribute(XML_NS_ATTRIBUTE, XML_NS_ATTRIBUTE_VALUE);
            builder.writeStartElement(HEADER_NODE);
            builder.writeSimpleElement(ENVELOPE_VERSION_NODE, ENVELOPE_VERSION);
            builder.writeSimpleElement(MESSAGE_CLASS_NODE, this.messageClass);
            builder.writeSimpleElement(QUALIFIER_NODE, this.qualifier);
            builder.writeSimpleElement(FUNCTION_NODE, this.function);
            builder.writeSimpleElement(ERIC_MESSAGEID_NODE, this.ericMessageId);
            builder.writeStartElement(ROUTING_NODE);
            builder.writeStartElement(CAPTURE_METHOD_NODE);
            builder.writeStartElement(this.captureMethod);
            if (this.captureMethod.equals(CAPTURE_METHOD_EDI)) {
                builder.writeSimpleElement(EDI_PARTNERID_NODE, this.tradingPartnerID);
                builder.writeSimpleElement(EDI_REF_NODE, this.ediRef);
                builder.writeStartElement(VENDOR_DETAILS_NODE);
                builder.writeSimpleElement(VENDOR_URI_NODE, this.vendorUri);
                builder.writeSimpleElement(VENDOR_NAME_NODE, this.vendorName);
                builder.writeSimpleElement(VENDOR_PRODUCT_NODE, this.vendorProduct);
                builder.writeSimpleElement(VENDOR_VERSION_NODE, this.vendorVersion);
                builder.writeEndElement();
            } else if (this.captureMethod.equals(CAPTURE_METHOD_PAPER)) {
                builder.writeSimpleElement(PROFORMAFLAG_NODE, this.paperProFormaFlag);
            }
            builder.writeEndElement();
            builder.writeEndElement();
            if (this.captureMethod.equals(CAPTURE_METHOD_EDI)) {
                builder.writeSimpleElement(SYSTEM_NODE, "BES");
            } else {
                builder.writeSimpleElement(SYSTEM_NODE, this.system);
            }
            builder.writeSimpleDateElement(CAPTURE_DATE_NODE, this.captureDate);
            builder.writeSimpleElement(CAPTUREID_NODE, this.captureId);
            builder.writeEndElement();
            builder.writeEndElement();
            if (this.error != null) {
                builder.writeStartElement(ERROR_RESPONSE_NODE);
                builder.writeStartElement(ERROR_NODE);
                builder.writeSimpleElement(RAISED_BY_NODE, this.error.getRaisedBy());
                builder.writeSimpleElement(NUMBER_NODE, this.error.getNumber());
                builder.writeSimpleElement(TYPE_NODE, this.error.getType());
                builder.writeSimpleElement(TEXT_NODE, this.error.getText());
                builder.writeSimpleElement(LOCATION_NODE, this.error.getLocation());
                builder.writeEndElement();
                builder.writeEndElement();
            }
            builder.writeStartElement(MESSAGE_BODY_NODE);
            this.generate(builder, this.messageBody);
            builder.endDocument();
        }
        catch (XMLBuilder.XMLBuilderException e) {
            throw new EnvelopeGeneratorException("Exception occured while generating Eric Envelope", e);
        }
    }

    private void init() throws EnvelopeGeneratorException {
        StringBuffer msg = new StringBuffer();
        String nodeSeperator = "/";
        String headerNode = "EricEnvelope/MessageHeader/";
        String routingNode = "EricEnvelope/MessageHeader/Routing/";
        if (this.messageClass == null) {
            this.appendMessage(msg, "EricEnvelope/MessageHeader/", MESSAGE_CLASS_NODE);
        }
        if (this.qualifier == null) {
            this.appendMessage(msg, "EricEnvelope/MessageHeader/", QUALIFIER_NODE);
        }
        if (this.function == null) {
            this.appendMessage(msg, "EricEnvelope/MessageHeader/", FUNCTION_NODE);
        }
        if (this.captureDate == null) {
            this.appendMessage(msg, "EricEnvelope/MessageHeader/Routing/", CAPTURE_DATE_NODE);
        }
        if (msg.length() != 0) {
            msg.append(" ]\n");
            throw new EnvelopeGeneratorException("Values for the following mandatory elements were not set [" + msg.toString());
        }
    }

    private void appendMessage(StringBuffer msg, String parentNode, String nodeName) {
        msg.append("\n");
        msg.append(parentNode);
        msg.append(nodeName);
    }

    public void setCaptureDate(Date captureDate) {
        this.captureDate = captureDate;
    }

    public void setCaptureId(String captureId) {
        this.captureId = captureId;
    }

    public void setCaptureMethod(String captureMethod) {
        this.captureMethod = captureMethod;
    }

    public void setEricMessageId(String ericMessageId) {
        this.ericMessageId = ericMessageId;
    }

    public void setFunction(String function) {
        this.function = function;
    }

    public void setMessageBody(ContentGenerator messageBody) {
        this.messageBody = messageBody;
    }

    public void setMessageClass(String messageClass) {
        this.messageClass = messageClass;
    }

    public void setQualifier(Qualifier qualifier) {
        this.qualifier = qualifier.getValue();
    }

    public void setSystem(String system) {
        this.system = system;
    }

    public void setError(Error error) {
        this.error = error;
    }

    public void setTradingPartnerID(String tradingPartnerID) {
        this.tradingPartnerID = tradingPartnerID;
    }

    public void setVendorName(String vendorName) {
        this.vendorName = vendorName;
    }

    public void setVendorProduct(String vendorProduct) {
        this.vendorProduct = vendorProduct;
    }

    public void setVendorUri(String vendorUri) {
        this.vendorUri = vendorUri;
    }

    public void setVendorVersion(String vendorVersion) {
        this.vendorVersion = vendorVersion;
    }

    public void setEdiRef(String ediRef) {
        this.ediRef = ediRef;
    }

    public void setPaperProFormaFlag(String paperProFormaFlag) {
        this.paperProFormaFlag = paperProFormaFlag;
    }

    public void setFtr(String ftr) {
        this.ftr = ftr;
    }
}

