/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.envelopeGenerators.govtalk;

import java.util.ArrayList;
import java.util.Date;
import uk.gov.hmrc.chris.utils.envelopeGenerators.ContentGenerator;
import uk.gov.hmrc.chris.utils.envelopeGenerators.EnvelopeGenerator;
import uk.gov.hmrc.chris.utils.envelopeGenerators.EnvelopeGeneratorException;
import uk.gov.hmrc.chris.utils.envelopeGenerators.govtalk.Error;
import uk.gov.hmrc.chris.utils.envelopeGenerators.govtalk.Function;
import uk.gov.hmrc.chris.utils.envelopeGenerators.govtalk.Method;
import uk.gov.hmrc.chris.utils.envelopeGenerators.govtalk.Processed;
import uk.gov.hmrc.chris.utils.envelopeGenerators.govtalk.Qualifier;
import uk.gov.hmrc.chris.utils.envelopeGenerators.govtalk.Result;
import uk.gov.hmrc.chris.utils.envelopeGenerators.govtalk.Transformation;
import uk.gov.hmrc.chris.utils.xml.XMLBuilder;

public class GovTalkGeneratorV2_0
extends EnvelopeGenerator {
    private static final String ROOT_NODE = "GovTalkMessage";
    private static final String XML_NS_ATTRIBUTE = "xmlns";
    private static final String XML_NS_ATTRIBUTE_VALUE = "http://www.govtalk.gov.uk/CM/envelope";
    private static final String ENVELOPE_VERSION_NODE = "EnvelopeVersion";
    private static final String HEADER_NODE = "Header";
    private static final String MESSAGE_DETAILS_NODE = "MessageDetails";
    private static final String CLASS_NODE = "Class";
    private static final String QUALIFIER_NODE = "Qualifier";
    private static final String FUNCTION_NODE = "Function";
    private static final String TRANSACTION_ID_NODE = "TransactionID";
    private static final String AUDIT_ID_NODE = "AuditID";
    private static final String CORRELATION_ID_NODE = "CorrelationID";
    private static final String RESPONSE_END_POINT_NODE = "ResponseEndPoint";
    private static final String POLLING_INTERVAL_ATTRIBUTE = "PollInterval";
    private static final String TRANSFORMATION_NODE = "Transformation";
    private static final String GATEWAY_TEST_NODE = "GatewayTest";
    private static final String GATEWAY_TIMESTAMP_NODE = "GatewayTimestamp";
    private static final String SENDER_DETAILS_NODE = "SenderDetails";
    private static final String IDAUTHENTICATION_NODE = "IDAuthentication";
    private static final String SENDER_ID_NODE = "SenderID";
    private static final String AUTHENTICATION_NODE = "Authentication";
    private static final String METHOD_NODE = "Method";
    private static final String ROLE_NODE = "Role";
    private static final String VALUE_NODE = "Value";
    private static final String X509_CERTIFICATE_NODE = "X509Certificate";
    private static final String EMAIL_ADDRESS_NODE = "EmailAddress";
    private static final String GOVTALK_DETAILS_NODE = "GovTalkDetails";
    private static final String KEYS_NODE = "Keys";
    private static final String KEY_NODE = "Key";
    private static final String TYPE_ATTRIBUTE = "Type";
    private static final String TARGET_DETAILS_NODE = "TargetDetails";
    private static final String ORGANISATION_NODE = "Organisation";
    private static final String GATEWAY_VALIADTION_NODE = "GatewayValidation";
    private static final String PROCESSED_NODE = "Processed";
    private static final String RESULT_NODE = "Result";
    private static final String CHANNEL_ROUTING_NODE = "ChannelRouting";
    private static final String CHANNEL_NODE = "Channel";
    private static final String URI_NODE = "URI";
    private static final String NAME_NODE = "Name";
    private static final String PRODUCT_NODE = "Product";
    private static final String VERSION_NODE = "Version";
    private static final String ID_NODE = "ID";
    private static final String TIMESTAMP_NODE = "Timestamp";
    private static final String GOVTALK_ERRORS_NODE = "GovTalkErrors";
    private static final String ERROR_NODE = "Error";
    private static final String RAISED_BY_NODE = "RaisedBy";
    private static final String NUMBER_NODE = "Number";
    private static final String TYPE_NODE = "Type";
    private static final String TEXT_NODE = "Text";
    private static final String LOCATION_NODE = "Location";
    private static final String GATEWAY_ADDITIONS_NODE = "GatewayAdditions";
    private static final String BODY_NODE = "Body";
    private static final String ENVELOPE_VERSION = "2.0";
    private String messageClass;
    private String qualifier;
    private String function;
    private String transactionID;
    private String auditID;
    private String correclationID;
    private String responseEndPoint;
    private String transforamtion;
    private String gatewayTest;
    private Date gatewayTimestamp;
    private String senderID;
    private ArrayList<Authentication> authentication = new ArrayList();
    private String x509Certificate;
    private String emailAddress;
    private ArrayList<Key> keys = new ArrayList();
    private ArrayList<String> organisations = new ArrayList();
    private Processed gatewayValidationProcessed;
    private Result gatewayValidationResult;
    private String channelURI;
    private String channelName;
    private String channelProduct;
    private String channelVersion;
    private ArrayList<ChannelID> channelID = new ArrayList();
    private Date channelTimestamp;
    private ArrayList<Error> errors = new ArrayList();
    private ContentGenerator gatewayAdditions;
    private ContentGenerator body;
    private String pollInterval;

    @Override
    protected void generateContent(XMLBuilder builder) throws EnvelopeGeneratorException {
        try {
            int x;
            builder.writeStartElement(ROOT_NODE);
            builder.writeAttribute(XML_NS_ATTRIBUTE, XML_NS_ATTRIBUTE_VALUE);
            builder.writeSimpleElement(ENVELOPE_VERSION_NODE, ENVELOPE_VERSION);
            builder.writeStartElement(HEADER_NODE);
            builder.writeStartElement(MESSAGE_DETAILS_NODE);
            builder.writeSimpleElement(CLASS_NODE, this.messageClass);
            builder.writeSimpleElement(QUALIFIER_NODE, this.qualifier);
            builder.writeSimpleElement(FUNCTION_NODE, this.function);
            builder.writeSimpleElement(TRANSACTION_ID_NODE, this.transactionID);
            builder.writeSimpleElement(AUDIT_ID_NODE, this.auditID);
            builder.writeSimpleElement(CORRELATION_ID_NODE, this.correclationID);
            builder.writeStartElement(RESPONSE_END_POINT_NODE);
            if (this.pollInterval != null && this.pollInterval.trim().length() > 0) {
                builder.writeAttribute(POLLING_INTERVAL_ATTRIBUTE, this.pollInterval);
            }
            builder.writeText(this.responseEndPoint);
            builder.writeEndElement();
            builder.writeSimpleElement(TRANSFORMATION_NODE, this.transforamtion);
            builder.writeSimpleElement(GATEWAY_TEST_NODE, this.gatewayTest);
            builder.writeEmptyElement(GATEWAY_TIMESTAMP_NODE);
            builder.writeEndElement();
            if (this.authentication.size() > 0 || this.x509Certificate != null || this.emailAddress != null) {
                builder.writeStartElement(SENDER_DETAILS_NODE);
                if (this.authentication.size() > 0) {
                    builder.writeStartElement(IDAUTHENTICATION_NODE);
                    builder.writeSimpleElement(SENDER_ID_NODE, this.senderID);
                    for (x = 0; x < this.authentication.size(); ++x) {
                        builder.writeStartElement(AUTHENTICATION_NODE);
                        builder.writeSimpleElement(METHOD_NODE, this.authentication.get(x).getMethod().getValue());
                        builder.writeSimpleElement(ROLE_NODE, this.authentication.get(x).getRole());
                        builder.writeSimpleElement(VALUE_NODE, this.authentication.get(x).getValue());
                        builder.writeEndElement();
                    }
                    builder.writeEndElement();
                }
                builder.writeSimpleElement(X509_CERTIFICATE_NODE, this.x509Certificate);
                builder.writeSimpleElement(EMAIL_ADDRESS_NODE, this.emailAddress);
                builder.writeEndElement();
            }
            builder.writeEndElement();
            builder.writeStartElement(GOVTALK_DETAILS_NODE);
            builder.writeStartElement(KEYS_NODE);
            for (x = 0; x < this.keys.size(); ++x) {
                Key key = this.keys.get(x);
                builder.writeStartElement(KEY_NODE);
                builder.writeAttribute("Type", key.getType());
                builder.writeText(key.getValue());
                builder.writeEndElement();
            }
            builder.writeEndElement();
            if (this.organisations.size() > 0) {
                builder.writeStartElement(TARGET_DETAILS_NODE);
                builder.writeSimpleElement(ORGANISATION_NODE, this.organisations);
                builder.writeEndElement();
            }
            if (this.gatewayValidationProcessed != null) {
                builder.writeStartElement(GATEWAY_VALIADTION_NODE);
                builder.writeSimpleElement(PROCESSED_NODE, this.gatewayValidationProcessed.getValue());
                builder.writeSimpleElement(RESULT_NODE, this.gatewayValidationResult.getValue());
                builder.writeEndElement();
            }
            if (this.channelURI != null || this.channelName != null) {
                builder.writeStartElement(CHANNEL_ROUTING_NODE);
                builder.writeStartElement(CHANNEL_NODE);
                builder.writeSimpleElement(URI_NODE, this.channelURI);
                builder.writeSimpleElement(NAME_NODE, this.channelName);
                builder.writeSimpleElement(PRODUCT_NODE, this.channelProduct);
                builder.writeSimpleElement(VERSION_NODE, this.channelVersion);
                builder.writeEndElement();
                for (x = 0; x < this.channelID.size(); ++x) {
                    ChannelID id = this.channelID.get(x);
                    builder.writeStartElement(ID_NODE);
                    builder.writeAttribute("Type", id.getType());
                    builder.writeText(id.getValue());
                    builder.writeEndElement();
                }
                builder.writeSimpleTimeStampElement(TIMESTAMP_NODE, this.channelTimestamp);
                builder.writeEndElement();
            }
            if (this.errors.size() > 0) {
                builder.writeStartElement(GOVTALK_ERRORS_NODE);
                for (x = 0; x < this.errors.size(); ++x) {
                    builder.writeStartElement(ERROR_NODE);
                    Error error = this.errors.get(x);
                    builder.writeSimpleElement(RAISED_BY_NODE, error.getRaisedBy());
                    builder.writeSimpleElement(NUMBER_NODE, error.getNumber());
                    builder.writeSimpleElement("Type", error.getType());
                    builder.writeSimpleElement(TEXT_NODE, error.getText());
                    builder.writeSimpleElement(LOCATION_NODE, error.getLocation());
                    builder.writeEndElement();
                }
                builder.writeEndElement();
            }
            if (this.gatewayAdditions != null) {
                builder.writeStartElement(GATEWAY_ADDITIONS_NODE);
                this.generate(builder, this.gatewayAdditions);
                builder.writeEndElement();
            }
            builder.writeEndElement();
            builder.writeStartElement(BODY_NODE);
            this.generate(builder, this.body);
            builder.writeEndElement();
        }
        catch (XMLBuilder.XMLBuilderException e) {
            throw new EnvelopeGeneratorException("Problem generating GovTalk", e);
        }
    }

    public void setAuditID(String auditID) {
        this.auditID = auditID;
    }

    public void setCorreclationID(String correclationID) {
        this.correclationID = correclationID;
    }

    public void setFunction(Function function) {
        this.function = function.getValue();
    }

    public void setGatewayTest(String gatewayTest) {
        this.gatewayTest = gatewayTest;
    }

    public void setGatewayTimestamp(Date gatewayTimestamp) {
        this.gatewayTimestamp = gatewayTimestamp;
    }

    public void setClass(String messageClass) {
        this.messageClass = messageClass;
    }

    public void setQualifier(Qualifier qualifier) {
        this.qualifier = qualifier.getValue();
    }

    public void setResponseEndPoint(String pollInterval, String responseEndPoint) {
        this.responseEndPoint = responseEndPoint;
        this.pollInterval = pollInterval;
    }

    public void setTransactionID(String transactionID) {
        this.transactionID = transactionID;
    }

    public void setTransforamtion(Transformation transforamtion) {
        if (transforamtion != null) {
            this.transforamtion = transforamtion.getValue();
        }
    }

    public void setAuthentication(Method method, String role, String value) {
        Authentication auth = new Authentication();
        auth.setMethod(method);
        auth.setRole(role);
        auth.setValue(value);
        this.authentication.add(auth);
    }

    public void setSenderID(String senderID) {
        this.senderID = senderID;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public void setX509Certificate(String certificate) {
        this.x509Certificate = certificate;
    }

    public void setBody(ContentGenerator body) {
        this.body = body;
    }

    public void addChannelID(String type, String value) {
        ChannelID id = new ChannelID();
        id.setType(type);
        id.setValue(value);
        this.channelID.add(id);
    }

    public void setChannelName(String channelName) {
        this.channelName = channelName;
    }

    public void setChannelProduct(String channelProduct) {
        this.channelProduct = channelProduct;
    }

    public void setChannelTimestamp(Date channelTimestamp) {
        this.channelTimestamp = channelTimestamp;
    }

    public void setChannelURI(String channelURI) {
        this.channelURI = channelURI;
    }

    public void setChannelVersion(String channelVersion) {
        this.channelVersion = channelVersion;
    }

    public void addError(Error error) {
        this.errors.add(error);
    }

    public void setGatewayAdditions(ContentGenerator gatewayAdditions) {
        this.gatewayAdditions = gatewayAdditions;
    }

    public void setGatewayValidationProcessed(Processed gatewayValidationProcessed) {
        this.gatewayValidationProcessed = gatewayValidationProcessed;
    }

    public void setGatewayValidationResult(Result gatewayValidationResult) {
        this.gatewayValidationResult = gatewayValidationResult;
    }

    public void addKey(String type, String value) {
        Key key = new Key();
        key.setType(type);
        key.setValue(value);
        this.keys.add(key);
    }

    public void addOrganisation(String organisation) {
        this.organisations.add(organisation);
    }

    private class Authentication {
        private Method method;
        private String role;
        private String value;

        private Authentication() {
        }

        private Method getMethod() {
            return this.method;
        }

        private void setMethod(Method method) {
            this.method = method;
        }

        private String getRole() {
            return this.role;
        }

        private void setRole(String role) {
            this.role = role;
        }

        private String getValue() {
            return this.value;
        }

        private void setValue(String value) {
            this.value = value;
        }
    }

    private class Key {
        private String type;
        private String value;

        private Key() {
        }

        private String getType() {
            return this.type;
        }

        private void setType(String type) {
            this.type = type;
        }

        private String getValue() {
            return this.value;
        }

        private void setValue(String value) {
            this.value = value;
        }
    }

    private class ChannelID {
        private String type;
        private String value;

        private ChannelID() {
        }

        private String getType() {
            return this.type;
        }

        private void setType(String type) {
            this.type = type;
        }

        private String getValue() {
            return this.value;
        }

        private void setValue(String value) {
            this.value = value;
        }
    }
}

