/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.exception;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import uk.gov.hmrc.chris.spox.DefaultListener;
import uk.gov.hmrc.chris.spox.SPOXException;
import uk.gov.hmrc.chris.spox.XMLHandler;
import uk.gov.hmrc.chris.spox.utils.SPOXUtils;
import uk.gov.hmrc.chris.spox.xml.Attribute;
import uk.gov.hmrc.chris.utils.streaming.StreamingException;
import uk.gov.hmrc.chris.utils.streaming.StringUtils;
import uk.gov.hmrc.chris.utils.xml.XMLBuilder;

public class SerializedException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private static final String EXCEPTION_ELEMENT = "Exception";
    private static final String MESSAGE_ELEMENT = "Message";
    private static final String THROWABLE_ELEMENT = "Throwable";
    private String message;
    private String throwable;

    public SerializedException(Throwable throwable) {
        super(throwable.getMessage(), throwable);
        if (throwable != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            throwable.printStackTrace(pw);
            this.throwable = sw.toString();
            try {
                sw.close();
                pw.close();
            }
            catch (Exception e) {
                throw new RuntimeException("Problem when serializing exception", e);
            }
        }
    }

    public SerializedException(InputStream xmlStream) {
        this.deserialise(xmlStream);
    }

    public SerializedException(String xml) {
        this.deserialise(xml);
    }

    @Override
    public String getMessage() {
        if (this.message != null) {
            return this.message;
        }
        return super.getMessage();
    }

    public String getThrowable() {
        return this.throwable;
    }

    public void serialise(OutputStream out) {
        try {
            XMLBuilder xmlb = new XMLBuilder((Boolean)true, out);
            xmlb.writeStartElement(EXCEPTION_ELEMENT);
            xmlb.writeSimpleElement(MESSAGE_ELEMENT, this.getMessage());
            xmlb.writeSimpleElement(THROWABLE_ELEMENT, this.getThrowable());
            xmlb.writeEndElement();
            xmlb.endDocument();
        }
        catch (Exception e) {
            throw new RuntimeException("Problem when serializing exception", e);
        }
    }

    protected void deserialise(String xml) {
        try {
            this.deserialise(StringUtils.convertStringToInputStream(xml));
        }
        catch (StreamingException e) {
            throw new RuntimeException("Problem when deserializing exception", e);
        }
    }

    protected void deserialise(InputStream xmlStream) {
        XMLHandler xmlh = new XMLHandler(new DefaultListener(){
            private StringBuilder messageBuffer = new StringBuilder();
            private StringBuilder throwableBuffer = new StringBuilder();
            private boolean messageFound;
            private boolean throwableFound;

            @Override
            public void startElementFound(String name, Attribute ... attributes) throws SPOXException {
                String nodeName = SPOXUtils.stripNameSpaceFromNode(name);
                this.messageFound = SerializedException.MESSAGE_ELEMENT.equals(nodeName);
                this.throwableFound = SerializedException.THROWABLE_ELEMENT.equals(nodeName);
            }

            @Override
            public void characterDataFound(char[] data, int Size) throws SPOXException {
                if (this.messageFound && this.messageBuffer != null) {
                    this.messageBuffer.append(data, 0, Size);
                } else if (this.throwableFound && this.throwableBuffer != null) {
                    this.throwableBuffer.append(data, 0, Size);
                }
            }

            @Override
            public void endElementFound(String name) throws SPOXException {
                if (this.messageFound) {
                    SerializedException.this.message = this.messageBuffer.toString();
                    this.messageBuffer = null;
                    this.messageFound = false;
                } else if (this.throwableFound) {
                    SerializedException.this.throwable = this.throwableBuffer.toString();
                    this.throwableBuffer = null;
                    this.throwableFound = false;
                }
            }

            @Override
            public String[] getXPaths() throws SPOXException {
                return new String[0];
            }
        });
        try {
            xmlh.readXML(xmlStream);
        }
        catch (Exception e) {
            throw new RuntimeException("Problem when deserializing exception", e);
        }
    }

    @Override
    public String toString() {
        return "Message: " + this.getMessage() + ", Throwable: " + this.getThrowable();
    }
}

