/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.expressway;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import uk.gov.hmrc.chris.ChRISBaseLogger;
import uk.gov.hmrc.chris.utils.transform.AbstractTransformEngineProxy;
import uk.gov.hmrc.chris.utils.transform.TransformEngineConfig;
import uk.gov.hmrc.chris.utils.transform.TransformEngineProxyException;
import uk.gov.hmrc.chris.utils.transform.TransformEngineResponse;

public class ExpresswayTransformEngineProxy
extends AbstractTransformEngineProxy {
    private HttpURLConnection conn = null;
    private int lastContentLength = 0;
    private int lastReturnCode = 0;
    private TransformEngineResponse response = new TransformEngineResponse();
    private static final String HTTP = "http";
    private static final String POST = "POST";
    private static final String CONTENT_HYPHEN_TYPE = "Content-Type";
    private static final String KEEP_ALIVE = "Keep-Alive";
    private static final String TRUE = "true";
    private static final String PRAGMA = "Pragma";
    private static final String NO_CACHE = "no-cache";
    private static final String CACHE_CONTROL = "Cache-Control";
    private static final String EXPIRES = "Expires";
    private static final String ZERO = "0";
    private static final String CONNECTION = "Connection";
    private static final String CLOSE = "close";
    private static final String ACCEPT = "Accept";
    private static final String ALL_MEDIA_TYPES = "*/*";
    private static final String SARVEGA_STYLESHEET = "expressway-stylesheet";
    private static final String XML_STYLESHEET = "xml-stylesheet";
    private static final String XSL = "xsl";
    private static final String APPLICATION_XML = "application/xml";

    public ExpresswayTransformEngineProxy(TransformEngineConfig config) {
        super(config);
    }

    @Override
    public int getLastReturnCode() {
        return this.lastReturnCode;
    }

    @Override
    public OutputStream openConnection() throws TransformEngineProxyException {
        return this.openConnection(null);
    }

    @Override
    public OutputStream openConnection(String styleSheet) throws TransformEngineProxyException {
        try {
            ChRISBaseLogger.info("Posting to " + this.getConfig().getHost() + ":" + this.getConfig().getPort() + this.getConfig().getUri());
            URL url = new URL(HTTP, this.getConfig().getHost(), this.getConfig().getPort(), this.getConfig().getUri());
            this.conn = (HttpURLConnection)url.openConnection();
            this.conn.setRequestMethod(POST);
            this.conn.setDoOutput(true);
            this.conn.setRequestProperty(CONTENT_HYPHEN_TYPE, APPLICATION_XML);
            this.conn.setRequestProperty(KEEP_ALIVE, TRUE);
            this.conn.setRequestProperty(PRAGMA, NO_CACHE);
            this.conn.setRequestProperty(CACHE_CONTROL, NO_CACHE);
            this.conn.setRequestProperty(EXPIRES, ZERO);
            this.conn.setRequestProperty(CONNECTION, CLOSE);
            this.conn.setRequestProperty(ACCEPT, ALL_MEDIA_TYPES);
            this.setStyleSheet(styleSheet);
            this.conn.setUseCaches(false);
            this.conn.setDoInput(true);
            if (this.getConfig().isHttpChunkingEnabled()) {
                this.conn.setChunkedStreamingMode(0);
            }
            return this.conn.getOutputStream();
        }
        catch (UnknownHostException e) {
            throw new TransformEngineProxyException("Unable to find the host.  Settings are :" + this.toString(), e);
        }
        catch (IOException e) {
            throw new TransformEngineProxyException("There has been an IO Exception.  Settings are :" + this.toString(), e);
        }
    }

    @Override
    public InputStream finishedPosting() throws TransformEngineProxyException {
        ChRISBaseLogger.debug("Finished posting - Waiting for reply");
        try {
            int code = this.conn.getResponseCode();
            String message = this.conn.getResponseMessage();
            this.response.setCode(code);
            this.response.setMessage(message);
            this.lastContentLength = this.conn.getContentLength();
            if (code != 200) {
                ChRISBaseLogger.info("Expressway returned a non 200 response [" + code + "] [" + this.conn.getResponseMessage() + "]");
                throw new TransformEngineProxyException("Expressway Error - Response code from expressway was " + code + " " + this.conn.getResponseMessage());
            }
            if (this.lastContentLength < 1) {
                ChRISBaseLogger.info("The content length is not valid for a transform (Zero Length)");
                throw new TransformEngineProxyException("The content length is not valid for a transform (Zero Length)");
            }
            InputStream inputStream = this.conn.getInputStream();
            return inputStream;
        }
        catch (SocketException se) {
            throw new TransformEngineProxyException("There has been a socket exception", se);
        }
        catch (IOException e) {
            throw new TransformEngineProxyException("There has been an IO exception sending the data", e);
        }
        finally {
            ChRISBaseLogger.debug("Finished posting - Reply received");
        }
    }

    @Override
    public int getLastContentLength() {
        return this.lastContentLength;
    }

    @Override
    public TransformEngineResponse getResponse() {
        return this.response;
    }

    @Override
    public void closeConnection() {
        if (this.conn != null) {
            this.conn.disconnect();
        }
    }

    protected void setStyleSheet(String styleSheet) {
        if (styleSheet != null) {
            this.conn.setRequestProperty(SARVEGA_STYLESHEET, styleSheet);
            this.conn.setRequestProperty(XML_STYLESHEET, styleSheet);
            this.conn.setRequestProperty(XSL, styleSheet);
        }
    }

    public String toString() {
        StringBuffer config = new StringBuffer();
        config.append("Host: ").append(this.getConfig().getHost()).append("\n").append("Port: ").append(this.getConfig().getPort()).append("\n").append("URI: ").append(this.getConfig().getUri()).append("\n");
        return config.toString();
    }
}

