/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.fileUtils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import uk.gov.hmrc.chris.utils.fileUtils.FileHandlerException;

public class FileUtil {
    private OutputStreamWriter osw = null;
    private String filename = null;

    public FileUtil(String fqfn, String encoding) throws FileHandlerException {
        File file = new File(fqfn);
        this.filename = file.getName();
        if (file.exists()) {
            throw new FileHandlerException("The File Already Exists", null);
        }
        try {
            if (!file.createNewFile()) {
                throw new FileHandlerException("Failure creating the file", null);
            }
        }
        catch (IOException e) {
            throw new FileHandlerException("IO Error creating the file", e);
        }
        try {
            this.osw = new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new FileHandlerException("The requested encoding is not supported", e);
        }
        catch (FileNotFoundException e) {
            throw new FileHandlerException("The file cound not be found", e);
        }
    }

    public void closeFile() throws FileHandlerException {
        try {
            this.osw.flush();
            this.osw.close();
        }
        catch (IOException e) {
            throw new FileHandlerException("Unable to close the file", e);
        }
    }

    public void writeLine(String line) throws FileHandlerException {
        String pLine = line;
        try {
            if (!pLine.endsWith("\n")) {
                pLine = pLine + "\n";
            }
            this.osw.write(pLine);
            this.osw.flush();
        }
        catch (IOException e) {
            throw new FileHandlerException("Unable to write the line", e);
        }
    }

    public void writeLine() throws FileHandlerException {
        try {
            this.osw.write("\n");
            this.osw.flush();
        }
        catch (IOException e) {
            throw new FileHandlerException("Unable to write the line", e);
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public void writeLine(char[] line, int len) throws FileHandlerException {
        try {
            this.osw.write(line, 0, len);
            this.osw.flush();
        }
        catch (IOException e) {
            throw new FileHandlerException("Unable to Write the line", e);
        }
    }

    public void write(char[] line, int len) throws FileHandlerException {
        try {
            this.osw.write(line, 0, len);
            this.osw.flush();
        }
        catch (IOException e) {
            throw new FileHandlerException("Unable to Write the data", e);
        }
    }
}

