/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.fileUtils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import uk.gov.hmrc.chris.utils.fileUtils.FileHandlerException;
import uk.gov.hmrc.chris.utils.streaming.StreamHandler;
import uk.gov.hmrc.chris.utils.streaming.StreamingException;
import weblogic.security.internal.FileUtilsException;

public class FileUtilities {
    private static final String WRITE_PROTECTED_ERROR = "The file is write protected. File : ";
    private static final String STREAM_WRITE_ERROR = "Error while writing stream to file : ";
    private static final int BUFFER = 2048;
    private static final int EOF = -1;
    private static final String MODE = "rw";

    private FileUtilities() {
    }

    public static File createFile(String filename) throws FileHandlerException {
        try {
            File file = new File(filename);
            if (!file.exists()) {
                file.createNewFile();
            }
            return file;
        }
        catch (IOException ioe) {
            throw new FileHandlerException("Unable to open the file " + filename, ioe);
        }
    }

    public static File createDirectory(String directory) throws FileHandlerException {
        try {
            File file = new File(directory);
            if (!file.exists()) {
                file.createNewFile();
            }
            return file;
        }
        catch (IOException ioe) {
            throw new FileHandlerException("Unable to open the file " + directory, ioe);
        }
    }

    public static File getFile(String filename) {
        return new File(filename);
    }

    public static File getDirectory(String directoryPath) {
        File file = new File(directoryPath);
        if (!file.exists()) {
            return null;
        }
        return file;
    }

    public static boolean moveFile(File original, File destination) {
        return original.renameTo(destination);
    }

    public static File[] listDirectoryChildren(File directory) throws FileHandlerException {
        if (!directory.isDirectory()) {
            throw new FileHandlerException("The directory : " + directory.getAbsolutePath() + " does not exist.");
        }
        return directory.listFiles();
    }

    public static boolean deleteFile(File file) {
        return file.delete();
    }

    public static void copyFile(File original, File newFile) throws FileHandlerException {
        try {
            InputStream source = FileUtilities.getBufferedInputStream(original);
            OutputStream destination = FileUtilities.getBufferedOutputStream(newFile);
            StreamHandler.streamData(source, destination);
            source.close();
            destination.close();
        }
        catch (IOException e) {
            throw new FileHandlerException("Copying File : " + original.getAbsolutePath() + " to : " + newFile.getAbsolutePath() + "Failed", e);
        }
        catch (StreamingException e) {
            throw new FileHandlerException("Problem streaming data", e);
        }
    }

    public static void randomFileWriter(File file, InputStream in) throws FileHandlerException {
        RandomAccessFile raf = null;
        if (!file.canWrite()) {
            throw new FileHandlerException(WRITE_PROTECTED_ERROR + file.getAbsolutePath(), null);
        }
        BufferedInputStream bin = null;
        try {
            int len;
            raf = new RandomAccessFile(file, MODE);
            bin = new BufferedInputStream(in);
            raf.seek(raf.length());
            byte[] buff = new byte[2048];
            while ((len = bin.read(buff, 0, 2048)) != -1) {
                raf.write(buff, 0, len);
            }
        }
        catch (FileNotFoundException ex) {
            throw new FileHandlerException("Seem to have mislaid the file", ex);
        }
        catch (IOException ex) {
            throw new FileHandlerException(STREAM_WRITE_ERROR + file.getAbsolutePath(), ex);
        }
        finally {
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (IOException ex) {}
            }
            if (bin != null) {
                try {
                    bin.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    public static void randomFileWriter(File file, Reader reader) throws FileHandlerException {
        RandomAccessFile raf = null;
        if (!file.canWrite()) {
            throw new FileHandlerException(WRITE_PROTECTED_ERROR, null);
        }
        BufferedReader bReader = null;
        try {
            int len;
            raf = new RandomAccessFile(file, MODE);
            bReader = new BufferedReader(reader);
            raf.seek(file.length());
            char[] buff = new char[2048];
            while ((len = bReader.read(buff, 0, 2048)) != -1) {
                raf.writeBytes(new String(buff).substring(0, len));
            }
        }
        catch (IOException ex) {
            throw new FileHandlerException(STREAM_WRITE_ERROR + file.getAbsolutePath(), ex);
        }
        finally {
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (Exception ex) {}
            }
            if (bReader != null) {
                try {
                    bReader.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    public static long calculateFileSizeInBytes(File file) {
        return file.length();
    }

    public static List<File> listFiles(File startDirectory) {
        ArrayList<File> files = new ArrayList<File>();
        File[] contents = startDirectory.listFiles();
        for (int x = 0; x < contents.length; ++x) {
            if (contents[x].isDirectory()) {
                files.addAll(FileUtilities.listFiles(contents[x]));
                continue;
            }
            files.add(contents[x]);
        }
        return files;
    }

    public static Reader getBufferedReader(File file) {
        try {
            return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new FileUtilsException("Could not create reader on this file due to encoding error: " + file.getAbsolutePath(), (Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new FileUtilsException("File not found: " + file.getAbsolutePath(), (Throwable)e);
        }
    }

    public static Writer getBufferedWriter(File file) {
        try {
            return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new FileUtilsException("Could not create reader on this file due to encoding error: " + file.getAbsolutePath(), (Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new FileUtilsException("File not found: " + file.getAbsolutePath(), (Throwable)e);
        }
    }

    public static OutputStream getBufferedOutputStream(File destination) throws FileHandlerException {
        try {
            return new BufferedOutputStream(new FileOutputStream(destination));
        }
        catch (FileNotFoundException e) {
            throw new FileHandlerException("Could not find file to write to", e);
        }
    }

    public static InputStream getBufferedInputStream(File destination) throws FileHandlerException {
        try {
            return new BufferedInputStream(new FileInputStream(destination));
        }
        catch (FileNotFoundException e) {
            throw new FileHandlerException("Could not find file to write to", e);
        }
    }

    public static void writeHeader(File destination, String header) throws FileHandlerException {
        FileUtilities.writeLine(destination, 0L, header);
    }

    public static void writeFooter(File destination, String footer) throws FileHandlerException {
        FileUtilities.writeLine(destination, destination.length(), footer);
    }

    public static void writeLine(File destination, long linePosition, String line) throws FileHandlerException {
        if (!destination.canWrite()) {
            throw new FileHandlerException(WRITE_PROTECTED_ERROR, null);
        }
        try {
            RandomAccessFile raf = new RandomAccessFile(destination, MODE);
            raf.seek(linePosition);
            raf.writeBytes(line);
            raf.close();
        }
        catch (IOException ioe) {
            throw new FileHandlerException("Unable to append new line char to file", ioe);
        }
    }

    public static int countLines(File file) throws FileHandlerException {
        int count = 0;
        try {
            RandomAccessFile raf = new RandomAccessFile(file, MODE);
            while (raf.readLine() != null) {
                ++count;
            }
            raf.close();
            return count;
        }
        catch (IOException ioe) {
            throw new FileHandlerException("Unable to count the file size ", ioe);
        }
    }

    public static void deleteFiles(File[] files, boolean silent) {
        int size = files.length;
        for (int i = 0; i < size; ++i) {
            FileUtilities.deleteFile(files[i]);
        }
    }

    public static File[] sortByDate(File[] list) {
        int i;
        int size = list.length;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        TreeMap<String, File> files = new TreeMap<String, File>();
        for (i = 0; i < size; ++i) {
            String key = sdf.format(new Date(list[i].lastModified())) + list[i].getName();
            files.put(key, list[i]);
        }
        i = 0;
        File[] returnList = new File[size];
        Iterator it = files.entrySet().iterator();
        while (it.hasNext()) {
            returnList[i++] = (File)it.next().getValue();
        }
        return returnList;
    }

    public static void deleteTree(File directory, boolean deleteFiles) {
        File[] files = directory.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                FileUtilities.deleteTree(files[i], deleteFiles);
                FileUtilities.deleteFile(files[i]);
                continue;
            }
            if (!deleteFiles) continue;
            FileUtilities.deleteFile(files[i]);
        }
        FileUtilities.deleteFile(directory);
    }

    public static String getCurrentDir() {
        try {
            return new File(".").getCanonicalPath();
        }
        catch (IOException e) {
            throw new RuntimeException("Problem when getting the current dir", e);
        }
    }
}

