/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.fileUtils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import uk.gov.hmrc.chris.utils.fileUtils.FileHandlerException;
import uk.gov.hmrc.chris.utils.fileUtils.FileUtil;
import uk.gov.hmrc.chris.utils.fileUtils.FileUtilities;
import uk.gov.hmrc.chris.utils.fileUtils.ZipUtilities;

public class HodFileUtilities {
    public static final String ERROR_FILE_SUFFIX = ".msg";
    public static final String CLOB_FILE_SUFFIX = ".clb";
    public static final String KEY_FILE_SUFFIX = ".key";
    public static final String ZIP_FILE_SUFFIX = ".zip";
    public static final String GZIP_FILE_SUFFIX = ".gz";
    public static final String MANIFEST_FILE_SUFFIX = ".man";
    public static final String ENCODING = "UTF-8";
    protected static final String TRANSFER_CONTROL = ".trs";
    protected static final String ARCHIVE_CONTROL = ".ar";
    protected static final String DATABASE_CONTROL = ".db";
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
    private String messageType;
    protected String rootDirectory;
    protected String filesCreatedDirectory;
    protected String transferDirectory;
    protected String archiveDirectory;
    protected String tempDirectory;
    protected String workingDirectory;
    private String fileCompressionType;
    private String archiveFileCompressionType;
    private long maxUncompressedArchiveFileSize;

    public HodFileUtilities(String messageType, String rootDir, String createDir, String transDir, String archDir, String tempDir, String workDir, String compressionType, String archiveCompressionType, long maxUncompressedArchiveFileSize) {
        this.messageType = messageType;
        this.rootDirectory = rootDir;
        this.filesCreatedDirectory = createDir;
        this.transferDirectory = transDir;
        this.archiveDirectory = archDir;
        this.tempDirectory = tempDir;
        this.workingDirectory = workDir;
        this.archiveFileCompressionType = archiveCompressionType;
        this.maxUncompressedArchiveFileSize = maxUncompressedArchiveFileSize;
        this.fileCompressionType = compressionType;
    }

    public static void deleteFiles(Map filenames, String directory) {
        String path = directory + File.separator;
        for (String filename : filenames.keySet()) {
            FileUtilities.deleteFile(FileUtilities.getFile(filename));
            FileUtilities.deleteFile(FileUtilities.getFile(path + filename + CLOB_FILE_SUFFIX));
            FileUtilities.deleteFile(FileUtilities.getFile(path + filename + KEY_FILE_SUFFIX));
            FileUtilities.deleteFile(FileUtilities.getFile(path + filename + ERROR_FILE_SUFFIX));
            FileUtilities.deleteFile(FileUtilities.getFile(path + filename + ZIP_FILE_SUFFIX));
            FileUtilities.deleteFile(FileUtilities.getFile(path + filename + GZIP_FILE_SUFFIX));
        }
    }

    public static List<String> getManifestFileList(File manifestFile) throws FileHandlerException {
        try {
            ArrayList<String> manifestFilelist = new ArrayList<String>();
            BufferedReader reader = new BufferedReader(new FileReader(manifestFile));
            String filename = reader.readLine();
            while (filename != null) {
                manifestFilelist.add(filename);
                filename = reader.readLine();
            }
            reader.close();
            return manifestFilelist;
        }
        catch (FileNotFoundException e) {
            throw new FileHandlerException("File " + manifestFile.getName() + " not found", e);
        }
        catch (IOException e) {
            throw new FileHandlerException("Error processing file " + manifestFile.getName(), e);
        }
    }

    public File[] getTransferFileList() {
        File directory = new File(this.transferDirectory);
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !file.isDirectory();
            }
        };
        return directory.listFiles(filter);
    }

    public Map<String, List<String>> getDBUpdateFilenames() throws FileHandlerException {
        HashMap<String, List<String>> returnMap = new HashMap<String, List<String>>();
        File directory = new File(this.filesCreatedDirectory);
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                String ext = HodFileUtilities.getExtension(file.getName());
                return ext.equalsIgnoreCase(HodFileUtilities.TRANSFER_CONTROL);
            }
        };
        File[] files = directory.listFiles(filter);
        String path = this.filesCreatedDirectory + File.separator;
        int size = files.length;
        for (int i = 0; i < size; ++i) {
            String zipname = HodFileUtilities.getFilename(files[i].getName());
            returnMap.put(zipname + this.getCompressedFileSuffix(this.fileCompressionType), this.getUniqueNames(HodFileUtilities.getManifestFileList(new File(path + zipname + MANIFEST_FILE_SUFFIX))));
        }
        return returnMap;
    }

    public List<String> getUniqueNames(List<String> fileList) {
        ArrayList<String> uniqueList = new ArrayList<String>();
        Iterator<String> it = fileList.iterator();
        while (it.hasNext()) {
            String filename = HodFileUtilities.getFilename(it.next());
            if (uniqueList.contains(filename)) continue;
            uniqueList.add(filename);
        }
        return uniqueList;
    }

    public File[] getFilesToPrepareForTransfer() {
        File directory = new File(this.filesCreatedDirectory);
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (!file.isDirectory()) {
                    String ext = HodFileUtilities.getExtension(file.getName());
                    return !ext.equalsIgnoreCase(HodFileUtilities.ZIP_FILE_SUFFIX) && !ext.equalsIgnoreCase(HodFileUtilities.GZIP_FILE_SUFFIX);
                }
                return false;
            }
        };
        return directory.listFiles(filter);
    }

    private String getCompressedFileSuffix(String compressionType) {
        if (compressionType.equalsIgnoreCase("zip")) {
            return ZIP_FILE_SUFFIX;
        }
        if (compressionType.equalsIgnoreCase("gzip")) {
            return GZIP_FILE_SUFFIX;
        }
        return null;
    }

    public static void moveFiles(String sourceLoc, String targetLoc, List filenames, boolean checkForSource) {
        boolean move = true;
        String sourcePath = sourceLoc + File.separator;
        String targetPath = targetLoc + File.separator;
        for (String filename : filenames) {
            File source = new File(sourcePath + filename);
            if (checkForSource) {
                move = source.exists();
            }
            if (!move) continue;
            FileUtilities.moveFile(source, new File(targetPath + filename));
        }
    }

    public static void copyFiles(String sourceLoc, String targetLoc, List files, boolean checkForSource) throws FileHandlerException {
        boolean copy = true;
        String sourcePath = sourceLoc + File.separator;
        String targetPath = targetLoc + File.separator;
        for (String filename : files) {
            File source = new File(sourcePath + filename);
            if (checkForSource) {
                copy = source.exists();
            }
            if (!copy) continue;
            FileUtilities.copyFile(source, new File(targetPath + filename));
        }
    }

    public void moveFilesToFilesCreatedDir(List filenames) {
        HodFileUtilities.moveFiles(this.workingDirectory, this.filesCreatedDirectory, filenames, false);
    }

    public void moveFilesToFilesCreatedDir(List filenames, boolean checkForSource) {
        HodFileUtilities.moveFiles(this.workingDirectory, this.filesCreatedDirectory, filenames, checkForSource);
    }

    protected void moveFilesToTransferDir(List<String> filenames, boolean checkForSource) {
        HodFileUtilities.moveFiles(this.filesCreatedDirectory, this.transferDirectory, filenames, checkForSource);
    }

    private void copyFilesToArchiveDir(List filenames, boolean checkForSource) throws FileHandlerException {
        HodFileUtilities.copyFiles(this.filesCreatedDirectory, this.archiveDirectory, filenames, checkForSource);
    }

    protected void moveFilesToArchiveDir(List<String> filenames, boolean tryCompression, boolean checkForSource) throws FileHandlerException {
        if (tryCompression) {
            List filesToMove = this.compressFilesToArchive(filenames);
            HodFileUtilities.moveFiles(this.filesCreatedDirectory, this.archiveDirectory, filesToMove, checkForSource);
            FileUtilities.deleteFiles(HodFileUtilities.listAsFileArray(this.filesCreatedDirectory, filenames), false);
        } else {
            HodFileUtilities.moveFiles(this.filesCreatedDirectory, this.archiveDirectory, filenames, checkForSource);
        }
    }

    public void prepareFilesForTransfer(long maxUncompressedFileSize) throws FileHandlerException {
        File[] files = this.getFilesToPrepareForTransfer();
        if ((files = FileUtilities.sortByDate(files)).length > 0) {
            if (this.fileCompressionType.equalsIgnoreCase("zip")) {
                this.doZip(files, maxUncompressedFileSize);
            } else if (this.fileCompressionType.equalsIgnoreCase("gzip")) {
                this.doGZip(files);
            } else {
                this.doUncompressed(files);
            }
        }
    }

    public void doZip(File[] files, long maxUncompressedSize) throws FileHandlerException {
        int filePtr = 0;
        File[] filesToCompress = this.getFilesBySize(files, maxUncompressedSize, filePtr);
        while (filesToCompress.length > 0) {
            String zipname = this.generateZipFilename();
            zipname = this.filesCreatedDirectory + File.separator + zipname + ZIP_FILE_SUFFIX;
            File manifest = HodFileUtilities.compressFilesZip(zipname, filesToCompress);
            this.createControlFile(HodFileUtilities.getFilename(manifest.getName()), TRANSFER_CONTROL);
            if (maxUncompressedSize <= 0L) break;
            filesToCompress = this.getFilesBySize(files, maxUncompressedSize, filePtr += filesToCompress.length);
        }
    }

    public void doZip(File[] files, String fileName) throws FileHandlerException {
        String zipname = fileName;
        zipname = this.filesCreatedDirectory + File.separator + zipname + ZIP_FILE_SUFFIX;
        File manifest = HodFileUtilities.compressFilesZip(zipname, files);
        this.createControlFile(HodFileUtilities.getFilename(manifest.getName()), TRANSFER_CONTROL);
    }

    public void doGZip(File[] files) throws FileHandlerException {
        String path = this.filesCreatedDirectory + File.separator;
        int size = files.length;
        for (int i = 0; i < size; ++i) {
            String zipname = HodFileUtilities.getFilename(files[i].getName());
            zipname = path + zipname + GZIP_FILE_SUFFIX;
            File manifest = HodFileUtilities.compressFilesGZip(zipname, files[i]);
            this.createControlFile(HodFileUtilities.getFilename(manifest.getName()), TRANSFER_CONTROL);
        }
    }

    public void postDatabaseUpdate(String filename) throws FileHandlerException {
        String path = this.filesCreatedDirectory + File.separator;
        File controlFile = new File(path + filename + TRANSFER_CONTROL);
        if (!controlFile.exists()) {
            throw new FileHandlerException("Cannot locate control file " + controlFile.getPath(), null);
        }
        this.createControlFile(HodFileUtilities.getFilename(filename), DATABASE_CONTROL);
        File manifest = new File(path + filename + MANIFEST_FILE_SUFFIX);
        List<String> filesToMove = HodFileUtilities.getManifestFileList(manifest);
        filesToMove.add(manifest.getName());
        this.moveFilesToArchiveDir(filesToMove, true, false);
        filesToMove.clear();
        filesToMove.add(filename + this.getCompressedFileSuffix(this.fileCompressionType));
        this.moveFilesToTransferDir(filesToMove, false);
        controlFile.delete();
        new File(path + filename + DATABASE_CONTROL).delete();
    }

    public void doUncompressed(File[] files) throws FileHandlerException {
        List<String> filenames = HodFileUtilities.getFileListAsNames(Arrays.asList(files));
        String fileSuffix = this.getCompressedFileSuffix(this.archiveFileCompressionType);
        if (fileSuffix != null) {
            ArrayList<String> localFilenames = new ArrayList<String>(filenames);
            List filesToMove = this.compressFilesToArchive(localFilenames);
            HodFileUtilities.moveFiles(this.filesCreatedDirectory, this.archiveDirectory, filesToMove, false);
            localFilenames.removeAll(filenames);
            FileUtilities.deleteFile(FileUtilities.getFile(this.filesCreatedDirectory + File.separator + (String)localFilenames.get(0)));
        } else {
            this.copyFilesToArchiveDir(filenames, true);
        }
        this.moveFilesToTransferDir(filenames, false);
    }

    private List compressFilesToArchive(List<String> filenames) throws FileHandlerException {
        List<String> returnFileList;
        String fileSuffix = this.getCompressedFileSuffix(this.archiveFileCompressionType);
        if (fileSuffix != null) {
            returnFileList = new ArrayList<String>();
            int filePtr = 0;
            File[] compressFiles = HodFileUtilities.listAsFileArray(this.filesCreatedDirectory, filenames);
            File[] filesToCompress = this.getFilesBySize(compressFiles, this.maxUncompressedArchiveFileSize, filePtr);
            while (filesToCompress.length > 0) {
                String zipname = this.generateZipFilename() + fileSuffix;
                String zipfile = this.filesCreatedDirectory + File.separator + zipname;
                File manifest = HodFileUtilities.compressFilesZip(zipfile, filesToCompress);
                String controlFilename = HodFileUtilities.getFilename(manifest.getName());
                this.createControlFile(controlFilename, ARCHIVE_CONTROL);
                filenames.add(controlFilename + ARCHIVE_CONTROL);
                returnFileList.add(zipname);
                returnFileList.add(manifest.getName());
                if (this.maxUncompressedArchiveFileSize > 0L) {
                    filesToCompress = this.getFilesBySize(compressFiles, this.maxUncompressedArchiveFileSize, filePtr += filesToCompress.length);
                    continue;
                }
                break;
            }
        } else {
            returnFileList = filenames;
            filenames.clear();
        }
        return returnFileList;
    }

    public List excludeFileTypes(List<String> filterList, List<String> excludes, List<String> removedList) {
        ArrayList<String> returnList = new ArrayList<String>();
        int size = filterList.size();
        for (int i = 0; i < size; ++i) {
            String filename = filterList.get(i);
            int index = filename.lastIndexOf(".");
            if (index > 0) {
                String ext = filename.substring(index);
                if (excludes.contains(ext)) {
                    removedList.add(filename);
                    continue;
                }
                returnList.add(filename);
                continue;
            }
            returnList.add(filename);
        }
        return returnList;
    }

    public File[] getFilesBySize(File[] files, long maxSize, int startIndex) {
        ArrayList<File> returnList = new ArrayList<File>();
        long fileSize = 0L;
        if (maxSize > 0L) {
            int arraySize = files.length;
            for (int i = startIndex; i < arraySize && fileSize < maxSize; ++i) {
                if ((fileSize += files[i].length()) > maxSize) continue;
                returnList.add(files[i]);
            }
            return HodFileUtilities.listAsFileArray(returnList);
        }
        return files;
    }

    private static List<String> getFileListAsNames(List<File> files) {
        ArrayList<String> names = new ArrayList<String>();
        Iterator<File> it = files.iterator();
        while (it.hasNext()) {
            names.add(it.next().getName());
        }
        return names;
    }

    public static File[] listAsFileArray(List<File> list) {
        return list.toArray(new File[list.size()]);
    }

    public static File[] listAsFileArray(String directory, List filelist) {
        File[] returnArray = new File[filelist.size()];
        int size = filelist.size();
        for (int i = 0; i < size; ++i) {
            returnArray[i] = new File(directory + File.separator + (String)filelist.get(i));
        }
        return returnArray;
    }

    private String generateZipFilename() {
        if (this.messageType.equalsIgnoreCase("CA_ARC")) {
            return "FBI" + this.sdf.format(new Date());
        }
        if (this.messageType.equalsIgnoreCase("EFILE_P38A")) {
            return "EFILE_P38" + this.sdf.format(new Date());
        }
        return this.messageType + this.sdf.format(new Date());
    }

    public static File compressFilesZip(String zipname, File[] filelist) throws FileHandlerException {
        String manifest = null;
        File zipfile = new File(zipname);
        File manifestFile = null;
        if (filelist.length > 0) {
            long timestamp = filelist[0].lastModified();
            try {
                ZipUtilities.createZipFile(zipfile, filelist);
                manifest = HodFileUtilities.getFilename(zipname) + MANIFEST_FILE_SUFFIX;
                zipfile.setLastModified(timestamp);
                manifestFile = HodFileUtilities.createManifest(manifest, filelist);
            }
            catch (RuntimeException e) {
                if (manifest != null) {
                    FileUtilities.deleteFile(FileUtilities.getFile(manifest));
                }
                FileUtilities.deleteFile(FileUtilities.getFile(zipfile.getAbsolutePath()));
                throw e;
            }
        }
        return manifestFile;
    }

    public static File compressFilesGZip(String gzipname, File file) throws FileHandlerException {
        String manifest = null;
        File gzipfile = null;
        File manifestFile = null;
        try {
            ZipUtilities.createGZipFile(file, new File(gzipname));
            gzipfile = new File(gzipname);
            gzipfile.setLastModified(file.lastModified());
            manifest = HodFileUtilities.getFilename(gzipname) + MANIFEST_FILE_SUFFIX;
            manifestFile = HodFileUtilities.createManifest(manifest, new File[]{file});
        }
        catch (RuntimeException e) {
            if (manifest != null) {
                FileUtilities.deleteFile(FileUtilities.getFile(manifest));
            }
            if (gzipfile != null) {
                FileUtilities.deleteFile(FileUtilities.getFile(gzipfile.getAbsolutePath()));
            }
            throw e;
        }
        return manifestFile;
    }

    private static File createManifest(String filename, File[] list) throws FileHandlerException {
        FileUtil manifest = new FileUtil(filename, ENCODING);
        int size = list.length;
        for (int i = 0; i < size; ++i) {
            manifest.writeLine(list[i].getName());
        }
        manifest.closeFile();
        return new File(filename);
    }

    private void createControlFile(String filename, String type) throws FileHandlerException {
        new FileUtil(this.filesCreatedDirectory + File.separator + filename + type, ENCODING).closeFile();
    }

    protected static String getFilename(String file) {
        String filename = null;
        if (file != null) {
            int index = file.lastIndexOf(".");
            filename = index > 0 ? file.substring(0, index) : file;
        }
        return filename;
    }

    protected static String getExtension(String file) {
        String ext = null;
        if (file != null) {
            int index = file.lastIndexOf(".");
            ext = index > 0 ? file.substring(index) : "";
        }
        return ext;
    }

    protected void ensureExists(String directory, boolean recreate) {
        File file = new File(directory);
        if (file.exists()) {
            if (recreate) {
                FileUtilities.deleteTree(file, true);
                file.mkdirs();
            }
        } else {
            file.mkdirs();
        }
    }
}

