/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.fileUtils;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import uk.gov.hmrc.chris.utils.fileUtils.FileHandlerException;
import uk.gov.hmrc.chris.utils.fileUtils.FileUtilities;
import uk.gov.hmrc.chris.utils.fileUtils.HodFileUtilities;

public class HodRestartFileUtilities
extends HodFileUtilities {
    public HodRestartFileUtilities(String messageType, String rootDir, String createDir, String transDir, String archDir, String tempDir, String workDir, String compressionType, String archiveCompressionType, long maxUncompressedArchiveFileSize) {
        super(messageType, rootDir, createDir, transDir, archDir, tempDir, workDir, compressionType, archiveCompressionType, maxUncompressedArchiveFileSize);
    }

    public void restart() throws FileHandlerException {
        this.checkDirStructure(true);
        if (this.filesExists(this.filesCreatedDirectory)) {
            this.cleanArchiveDir();
            this.cleanTransferDir();
            this.cleanFilesCreatedDir();
            if (this.filesExists(this.filesCreatedDirectory)) {
                this.checkTransferControlFiles();
                if (this.filesExists(this.filesCreatedDirectory)) {
                    this.checkArchivedManifests();
                    if (this.filesExists(this.filesCreatedDirectory)) {
                        this.checkCompressedFiles();
                    }
                }
            }
        }
    }

    public void checkDirStructure(boolean deleteTemp) {
        this.ensureExists(this.rootDirectory, false);
        this.ensureExists(this.filesCreatedDirectory, false);
        this.ensureExists(this.archiveDirectory, false);
        this.ensureExists(this.tempDirectory, deleteTemp);
        this.ensureExists(this.workingDirectory, true);
        this.ensureExists(this.transferDirectory, false);
    }

    private void cleanArchiveDir() throws FileHandlerException {
        File createdDir = new File(this.filesCreatedDirectory);
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !file.isDirectory();
            }
        };
        File[] filelist = createdDir.listFiles(filter);
        String path = this.archiveDirectory + File.separator;
        int size = filelist.length;
        for (int i = 0; i < size; ++i) {
            if (FileUtilities.deleteFile(FileUtilities.getFile(path + filelist[i].getName()))) continue;
            throw new FileHandlerException("Did not delete file", null);
        }
    }

    private void cleanTransferDir() throws FileHandlerException {
        File createdDir = new File(this.filesCreatedDirectory);
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !file.isDirectory();
            }
        };
        File[] filelist = createdDir.listFiles(filter);
        String path = this.transferDirectory + File.separator;
        int size = filelist.length;
        for (int i = 0; i < size; ++i) {
            if (FileUtilities.deleteFile(FileUtilities.getFile(path + filelist[i].getName()))) continue;
            throw new FileHandlerException("Did not delete file", null);
        }
    }

    private void cleanFilesCreatedDir() {
        File createdDir = new File(this.filesCreatedDirectory);
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                String ext = HodFileUtilities.getExtension(file.getName());
                return ext.equalsIgnoreCase(".zip") || ext.equalsIgnoreCase(".gz");
            }
        };
        File[] filelist = createdDir.listFiles(filter);
        String path = this.filesCreatedDirectory + File.separator;
        int size = filelist.length;
        for (int i = 0; i < size; ++i) {
            String filename = HodRestartFileUtilities.getFilename(filelist[i].getName());
            if (this.controlFileExists(filename, ".trs")) continue;
            File[] filesToDelete = new File[]{filelist[i], new File(path + filename + ".man")};
            FileUtilities.deleteFiles(filesToDelete, false);
        }
    }

    private void checkTransferControlFiles() throws FileHandlerException {
        File createdDir = new File(this.filesCreatedDirectory);
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                String ext = HodFileUtilities.getExtension(file.getName());
                return ext.equalsIgnoreCase(".trs");
            }
        };
        File[] transferControlFile = createdDir.listFiles(filter);
        String path = this.filesCreatedDirectory + File.separator;
        int size = transferControlFile.length;
        for (int i = 0; i < size; ++i) {
            String filename = HodRestartFileUtilities.getFilename(transferControlFile[i].getName());
            File dbControlFile = new File(path + filename + ".db");
            if (dbControlFile.exists()) {
                this.completeArchiveMove(filename);
                this.completeTransferMove(filename);
                dbControlFile.delete();
                continue;
            }
            File[] filesToDelete = new File[]{new File(path + filename + ".zip"), new File(path + filename + ".gz"), new File(path + filename + ".man"), new File(path + filename + ".trs")};
            FileUtilities.deleteFiles(filesToDelete, false);
        }
    }

    private void checkCompressedFiles() throws FileHandlerException {
        File directory = new File(this.filesCreatedDirectory);
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                String ext = HodFileUtilities.getExtension(file.getName());
                return ext.equalsIgnoreCase(".ar");
            }
        };
        File[] compressedFiles = directory.listFiles(filter);
        ArrayList<String> filesToMove = new ArrayList<String>();
        ArrayList<File> filesToDelete = new ArrayList<File>();
        String createdPath = this.filesCreatedDirectory + File.separator;
        int size = compressedFiles.length;
        for (int i = 0; i < size; ++i) {
            String transferMainfest2 = "";
            String archiveManifest = HodRestartFileUtilities.getFilename(compressedFiles[i].getName());
            File manifestFile = new File(createdPath + archiveManifest + ".man");
            if (manifestFile.exists()) {
                List<String> transferFiles = HodRestartFileUtilities.getManifestFileList(manifestFile);
                filesToMove.clear();
                filesToMove.add(archiveManifest + ".zip");
                filesToMove.add(archiveManifest + ".gz");
                filesToMove.add(archiveManifest + ".man");
                this.moveFilesToArchiveDir(filesToMove, false, true);
                filesToMove.clear();
                filesToDelete.clear();
                for (String transferMainfest2 : transferFiles) {
                    if (!HodRestartFileUtilities.getExtension(transferMainfest2).equalsIgnoreCase(".man")) continue;
                    filesToMove.add(transferMainfest2 + ".zip");
                    filesToMove.add(transferMainfest2 + ".gz");
                    filesToMove.add(transferMainfest2);
                    List<String> manifestList = HodRestartFileUtilities.getManifestFileList(new File(directory + transferMainfest2));
                    for (String manifest : manifestList) {
                        filesToDelete.add(new File(manifest));
                    }
                    filesToDelete.add(new File(directory + HodRestartFileUtilities.getFilename(transferMainfest2) + ".trs"));
                    this.moveFilesToTransferDir(filesToMove, false);
                    break;
                }
                if (filesToMove.size() == 0) {
                    this.moveFilesToTransferDir(transferFiles, false);
                }
            }
            filesToDelete.add(new File(createdPath + archiveManifest + ".ar"));
            FileUtilities.deleteFiles(HodRestartFileUtilities.listAsFileArray(filesToDelete), false);
        }
    }

    private void checkArchivedManifests() throws FileHandlerException {
        File directory = new File(this.archiveDirectory);
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                String ext = HodFileUtilities.getExtension(file.getName());
                return ext.equalsIgnoreCase(".man");
            }
        };
        File[] manifests = directory.listFiles(filter);
        String createdPath = this.filesCreatedDirectory + File.separator;
        ArrayList<String> filesToMove = new ArrayList<String>();
        ArrayList<File> filesToDelete = new ArrayList<File>();
        int size = manifests.length;
        for (int i = 0; i < size; ++i) {
            List<String> files = HodRestartFileUtilities.getManifestFileList(manifests[i]);
            for (String file : files) {
                if (HodRestartFileUtilities.getExtension(file).equalsIgnoreCase(".man")) {
                    String filename = HodRestartFileUtilities.getFilename(file);
                    filesToMove.clear();
                    filesToMove.add(filename + ".zip");
                    filesToMove.add(filename + ".gz");
                    ArrayList<String> tmp = new ArrayList<String>(files);
                    Iterator d = tmp.iterator();
                    while (d.hasNext()) {
                        filesToDelete.add(new File(createdPath + (String)d.next()));
                    }
                    filesToDelete.add(new File(createdPath + HodRestartFileUtilities.getFilename(file) + ".trs"));
                    break;
                }
                filesToMove.add(file);
            }
            this.moveFilesToTransferDir(filesToMove, true);
            FileUtilities.deleteFiles(HodRestartFileUtilities.listAsFileArray(filesToDelete), false);
        }
    }

    private void completeTransferMove(String baseFilename) {
        ArrayList<String> filesToMove = new ArrayList<String>();
        filesToMove.add(baseFilename + ".zip");
        filesToMove.add(baseFilename + ".gz");
        this.moveFilesToTransferDir(filesToMove, true);
        new File(this.filesCreatedDirectory + File.separator + baseFilename + ".trs").delete();
    }

    private void completeArchiveMove(String baseFilename) throws FileHandlerException {
        String compressedArchiveFile = HodRestartFileUtilities.getFilename(this.findCompressedArchive(this.filesCreatedDirectory, baseFilename));
        String path = this.filesCreatedDirectory + File.separator;
        List<Object> filesToMove = new ArrayList<String>();
        if (compressedArchiveFile == null) {
            filesToMove = HodRestartFileUtilities.getManifestFileList(new File(path + baseFilename + ".man"));
            filesToMove.add(baseFilename + ".man");
            this.moveFilesToArchiveDir(filesToMove, true, false);
        } else {
            filesToMove.add(compressedArchiveFile + ".zip");
            filesToMove.add(compressedArchiveFile + ".gz");
            filesToMove.add(compressedArchiveFile + ".man");
            this.moveFilesToArchiveDir(filesToMove, false, true);
            new File(path + baseFilename + ".man").delete();
        }
        new File(path + compressedArchiveFile + ".ar").delete();
    }

    private String findCompressedArchive(String startDirectory, String baseFilename) throws FileHandlerException {
        String compressedArchive = null;
        File directory = new File(startDirectory);
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                String ext = HodFileUtilities.getExtension(file.getName());
                return ext.equalsIgnoreCase(".man");
            }
        };
        File[] manifestFiles = directory.listFiles(filter);
        String manifestFile = baseFilename + ".man";
        int size = manifestFiles.length;
        for (int i = 0; i < size && compressedArchive == null; ++i) {
            List<String> manifestFileList = HodRestartFileUtilities.getManifestFileList(manifestFiles[i]);
            if (!manifestFileList.contains(manifestFile)) continue;
            compressedArchive = HodRestartFileUtilities.getFilename(manifestFiles[i].getName());
        }
        if (compressedArchive == null && startDirectory.equals(this.filesCreatedDirectory)) {
            return this.findCompressedArchive(this.archiveDirectory, baseFilename);
        }
        return compressedArchive;
    }

    private boolean controlFileExists(String filename, String type) {
        boolean exists = new File(this.filesCreatedDirectory + File.separator + filename + type).exists();
        if (!exists) {
            exists = new File(this.filesCreatedDirectory + File.separator + filename + ".ar").exists();
        }
        return exists;
    }

    private boolean filesExists(String directory) {
        File dir = new File(directory);
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !file.isDirectory();
            }
        };
        File[] files = dir.listFiles(filter);
        return files.length > 0;
    }
}

