/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.fileUtils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import uk.gov.hmrc.chris.utils.fileUtils.FileHandlerException;

public class ZipUtilities {
    private static final int BUFFER = 2048;
    private static final int EOF = -1;
    private static final String TEMP_DIR = "./ZIPUTILSTEMP";

    public static void createZipFile(String filename, File[] files) throws ZipUtilitiesException {
        File file = new File(filename);
        ZipUtilities.createZipFile(file, files);
    }

    public static void createZipFile(File zipFile, File[] files) throws ZipUtilitiesException {
        if (zipFile.exists() && !zipFile.delete()) {
            throw new ZipUtilitiesException("Unable to create the zip file as it already exists and can't be deleted: " + zipFile.getAbsolutePath(), null);
        }
        try {
            if (!zipFile.createNewFile()) {
                throw new ZipUtilitiesException("Unable to create the zip file : " + zipFile.getAbsolutePath(), null);
            }
        }
        catch (IOException ex) {
            throw new ZipUtilitiesException("An error has occured whilst creating the zip file : " + zipFile.getAbsolutePath(), ex);
        }
        BufferedInputStream bin = null;
        ZipOutputStream zout = null;
        byte[] data = new byte[2048];
        try {
            zout = new ZipOutputStream(new FileOutputStream(zipFile));
            for (int x = 0; x < files.length; ++x) {
                int bytesRead;
                bin = new BufferedInputStream(new FileInputStream(files[x]));
                zout.putNextEntry(new ZipEntry(files[x].getName()));
                while ((bytesRead = bin.read(data, 0, 2048)) != -1) {
                    zout.write(data, 0, bytesRead);
                }
                bin.close();
            }
            zout.flush();
        }
        catch (IOException ex) {
            throw new ZipUtilitiesException("An error has occured whilst creating the zip file : " + zipFile.getAbsolutePath() + " source files: " + ZipUtilities.listFiles(files), ex);
        }
        finally {
            if (zout != null) {
                try {
                    zout.close();
                }
                catch (IOException ex) {
                    throw new ZipUtilitiesException("Could not create zip file - error whilst closing output stream : " + zipFile.getAbsolutePath() + " source files: " + ZipUtilities.listFiles(files), ex);
                }
            }
            if (bin != null) {
                try {
                    bin.close();
                }
                catch (IOException ex) {
                    throw new ZipUtilitiesException("Could not create zip file - error whilst closing input stream : " + zipFile.getAbsolutePath() + " source files: " + ZipUtilities.listFiles(files), ex);
                }
            }
        }
    }

    protected static String listFiles(File[] files) {
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < files.length; ++i) {
            ret.append(files[i] != null ? files[i].getAbsolutePath() : " null ");
            ret.append(" ,");
        }
        return ret.toString();
    }

    public static void addFilesToZip(String filename, File[] files) throws ZipUtilitiesException {
        File file = new File(filename);
        ZipUtilities.addFilesToZip(file, files);
    }

    public static void addFilesToZip(File zip, File[] filesToAdd) throws ZipUtilitiesException {
        if (!zip.exists()) {
            ZipUtilities.createZipFile(zip, filesToAdd);
        } else {
            try {
                File tempDir = new File(TEMP_DIR);
                tempDir.mkdir();
                ZipUtilities.extractZipFile(tempDir, zip);
                ZipUtilities.moveFiles(filesToAdd, tempDir);
                zip.delete();
                zip.createNewFile();
                ZipUtilities.createZipFile(zip, tempDir.listFiles());
                File[] delFiles = tempDir.listFiles();
                for (int x = 0; x < delFiles.length; ++x) {
                    delFiles[x].delete();
                }
                tempDir.delete();
            }
            catch (Exception ex) {
                throw new ZipUtilitiesException("An error has occured whils trying to add the files to the zip ", null);
            }
        }
    }

    private static void moveFiles(File[] files, File directory) throws ZipUtilitiesException {
        if (!directory.exists()) {
            if (!directory.mkdir()) {
                throw new ZipUtilitiesException("An error has occured whilst creating the directory : " + directory.getAbsolutePath(), null);
            }
        } else {
            if (!directory.isDirectory()) {
                throw new ZipUtilitiesException("The directory : " + directory.getAbsolutePath() + " is not a directory", null);
            }
            for (int x = 0; x < files.length; ++x) {
                File newFile = new File(directory + File.separator + files[x].getName());
                if (!files[x].renameTo(newFile)) {
                    throw new ZipUtilitiesException("An error has occured whilst moving the file : " + files[x].getAbsolutePath() + " to the directory : " + directory.getAbsolutePath(), null);
                }
                files[x].delete();
            }
        }
    }

    public static void extractZipFile(File directory, File zip) throws ZipUtilitiesException {
        if (!zip.exists()) {
            throw new ZipUtilitiesException("The zip file : " + zip.getAbsolutePath() + " does not exist", null);
        }
        ZipInputStream zin = null;
        FilterOutputStream bout = null;
        try {
            ZipEntry entry;
            zin = new ZipInputStream(new BufferedInputStream(new FileInputStream(zip)));
            while ((entry = zin.getNextEntry()) != null) {
                int count;
                byte[] data = new byte[2048];
                bout = new BufferedOutputStream(new FileOutputStream(directory + File.separator + entry.getName()), 2048);
                while ((count = zin.read(data, 0, 2048)) != -1) {
                    ((BufferedOutputStream)bout).write(data, 0, count);
                }
                ((BufferedOutputStream)bout).flush();
                bout.close();
            }
        }
        catch (Exception ex) {
            throw new ZipUtilitiesException("An error has occurred extracting the zip file : " + zip.getAbsolutePath() + " to the directory : " + directory.getAbsolutePath(), ex);
        }
        finally {
            if (bout != null) {
                try {
                    bout.close();
                }
                catch (Exception ex) {
                    throw new ZipUtilitiesException("Error closing outputstream in final block. An error has occurred extracting the zip file : " + zip.getAbsolutePath() + " to the directory : " + directory.getAbsolutePath(), ex);
                }
            }
            if (zin != null) {
                try {
                    zin.close();
                }
                catch (Exception ex) {
                    throw new ZipUtilitiesException("Error closing inputstream in final block. An error has occurred extracting the zip file : " + zip.getAbsolutePath() + " to the directory : " + directory.getAbsolutePath(), ex);
                }
            }
        }
    }

    public static File extractFile(String zipName, String filename) throws ZipUtilitiesException {
        File file = new File(zipName);
        return ZipUtilities.extractFile(file, filename);
    }

    public static File extractFile(File zip, String filename) throws ZipUtilitiesException {
        ZipInputStream zin = null;
        FilterOutputStream bout = null;
        try {
            int count;
            ZipEntry entry;
            byte[] data = new byte[2048];
            zin = new ZipInputStream(new BufferedInputStream(new FileInputStream(zip)));
            while ((entry = zin.getNextEntry()) != null && !entry.getName().equalsIgnoreCase(filename)) {
            }
            if (entry == null) {
                throw new ZipUtilitiesException("Unable to extract the file as it doesn;t exist in the zip", null);
            }
            File output = new File(entry.getName());
            bout = new BufferedOutputStream(new FileOutputStream(zip.getParent() + File.separator + output), 2048);
            while ((count = zin.read(data, 0, 2048)) != -1) {
                ((BufferedOutputStream)bout).write(data, 0, count);
            }
            ((BufferedOutputStream)bout).flush();
            File file = output;
            return file;
        }
        catch (IOException ex) {
            throw new ZipUtilitiesException("An Error has occured whilst extracting the zip.", ex);
        }
        finally {
            if (bout != null) {
                try {
                    bout.close();
                }
                catch (Exception ex) {
                    throw new ZipUtilitiesException("An Error has occured whilst extracting " + filename + " from the zip:" + zip.getAbsolutePath() + " Could not close output stream.", ex);
                }
            }
            if (zin != null) {
                try {
                    zin.close();
                }
                catch (Exception ex) {
                    throw new ZipUtilitiesException("An Error has occured whilst extracting " + filename + " from the zip:" + zip.getAbsolutePath() + " Could not close input stream.", ex);
                }
            }
        }
    }

    public static void removeFile(String filename, String fileToRemove) throws ZipUtilitiesException {
        File file = new File(filename);
        ZipUtilities.removeFile(file, fileToRemove);
    }

    public static void removeFile(File zipFile, String filetoRemove) throws ZipUtilitiesException {
        int x;
        File tempDIR = new File(TEMP_DIR);
        if (!tempDIR.mkdir()) {
            throw new ZipUtilitiesException("A Problem has occurred whislt removing the file : " + filetoRemove + " from the zip : " + zipFile.getAbsolutePath(), null);
        }
        ZipUtilities.extractZipFile(tempDIR, zipFile);
        File[] zipContents = tempDIR.listFiles();
        boolean found = false;
        for (x = 0; x < zipContents.length; ++x) {
            if (!zipContents[x].getName().equalsIgnoreCase(filetoRemove)) continue;
            zipContents[x].delete();
            found = true;
            break;
        }
        if (!found) {
            throw new ZipUtilitiesException("Unable to find the file : " + filetoRemove + " within the zip : " + zipFile.getAbsolutePath(), null);
        }
        zipFile.delete();
        zipContents = tempDIR.listFiles();
        ZipUtilities.createZipFile(zipFile, zipContents);
        for (x = 0; x < zipContents.length; ++x) {
            zipContents[x].delete();
        }
        tempDIR.delete();
    }

    public static void createGZipFile(String fileToGzip) throws ZipUtilitiesException {
        File file = new File(fileToGzip);
        ZipUtilities.createGZipFile(file, null);
    }

    public static File createGZipFile(File pSourceFile) throws ZipUtilitiesException {
        File defaultGzipFile = new File(pSourceFile.getAbsolutePath() + ".gz");
        ZipUtilities.createGZipFile(pSourceFile, defaultGzipFile);
        return defaultGzipFile;
    }

    public static void createGZipFile(File pSourceFile, File pGzFile) throws ZipUtilitiesException {
        if (!pSourceFile.exists()) {
            throw new ZipUtilitiesException("The File : " + pSourceFile.getAbsolutePath() + " does not exist", null);
        }
        if (pSourceFile.isDirectory()) {
            throw new ZipUtilitiesException("The file : " + pSourceFile.getAbsolutePath() + " is a directory", null);
        }
        DeflaterOutputStream gzout = null;
        BufferedInputStream bin = null;
        try {
            int count;
            gzout = new GZIPOutputStream(new FileOutputStream(pGzFile));
            bin = new BufferedInputStream(new FileInputStream(pSourceFile), 2048);
            byte[] data = new byte[2048];
            while ((count = bin.read(data, 0, 2048)) != -1) {
                ((GZIPOutputStream)gzout).write(data, 0, count);
            }
            gzout.flush();
        }
        catch (FileNotFoundException ex) {
            throw new ZipUtilitiesException("An error has occured whilst trying to compress the file : " + pSourceFile.getAbsolutePath() + " to the GZIp format", ex);
        }
        catch (IOException ex) {
            throw new ZipUtilitiesException("An error has occured whilst trying to compress the file : " + pSourceFile.getAbsolutePath() + " to the GZIp format", ex);
        }
        finally {
            if (gzout != null) {
                try {
                    gzout.close();
                }
                catch (Exception ex) {
                    throw new ZipUtilitiesException("An error has occured whilst trying to compress the file : " + pSourceFile.getAbsolutePath() + " to the GZIp format", ex);
                }
            }
            if (bin != null) {
                try {
                    bin.close();
                }
                catch (Exception ex) {
                    throw new ZipUtilitiesException("An error has occured whilst trying to compress the file : " + pSourceFile.getAbsolutePath() + " to the GZIp format", ex);
                }
            }
        }
    }

    public static void createGZipFile(InputStream input, String filename) throws ZipUtilitiesException {
        DeflaterOutputStream out = null;
        BufferedInputStream in = null;
        byte[] data = new byte[2048];
        try {
            int count;
            out = new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(filename), 2048));
            in = new BufferedInputStream(input, 2048);
            while ((count = in.read(data, 0, 2048)) != -1) {
                ((GZIPOutputStream)out).write(data, 0, count);
            }
            out.flush();
        }
        catch (IOException ex) {
            throw new ZipUtilitiesException("An error has occured whilst writing the gzip file : " + filename, ex);
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException ex) {
                    throw new ZipUtilitiesException("An error has occured whilst trying to compress the file : " + filename + " to the GZIp format", ex);
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    public static void extractGZipFile(String gZipFilename) throws ZipUtilitiesException {
        File file = new File(gZipFilename);
        ZipUtilities.extractGZipFile(file, null);
    }

    public static void extractGZipFile(File file, String filename) throws ZipUtilitiesException {
        String name;
        if (!file.exists()) {
            throw new ZipUtilitiesException("The file : " + file.getAbsolutePath() + " does not exist", null);
        }
        if (file.isDirectory()) {
            throw new ZipUtilitiesException("The File : " + file.getAbsolutePath() + " is a directory", null);
        }
        GZIPInputStream gzin = null;
        FilterOutputStream bout = null;
        if (filename == null) {
            name = file.getAbsolutePath();
            int x = (name = name.toLowerCase()).lastIndexOf(".gz");
            if (x != -1) {
                name = name.substring(0, x);
            }
        } else {
            name = filename;
        }
        try {
            int count;
            gzin = new GZIPInputStream(new BufferedInputStream(new FileInputStream(file), 2048));
            bout = new BufferedOutputStream(new FileOutputStream(name), 2048);
            byte[] data = new byte[2048];
            while ((count = gzin.read(data, 0, 2048)) != -1) {
                ((BufferedOutputStream)bout).write(data, 0, count);
            }
            ((BufferedOutputStream)bout).flush();
        }
        catch (FileNotFoundException ex) {
            throw new ZipUtilitiesException("An error has occured whilst trying to extract the gzip file : " + file.getAbsolutePath(), ex);
        }
        catch (IOException ex) {
            throw new ZipUtilitiesException("An error has occured whilst trying to extract the gzip file : " + file.getAbsolutePath(), ex);
        }
        finally {
            if (bout != null) {
                try {
                    bout.close();
                }
                catch (IOException ex) {
                    throw new ZipUtilitiesException("An error has occured whilst trying to extract the gzip file : " + file.getAbsolutePath(), ex);
                }
            }
            if (gzin != null) {
                try {
                    gzin.close();
                }
                catch (IOException ex) {
                    throw new ZipUtilitiesException("An error has occured whilst trying to extract the gzip file : " + file.getAbsolutePath(), ex);
                }
            }
        }
    }

    public static Enumeration listZipContents(File zip) throws ZipUtilitiesException {
        if (!zip.exists()) {
            throw new ZipUtilitiesException("The zip file : " + zip.getAbsolutePath() + " doesn't exist", null);
        }
        try {
            ZipFile zipFile = new ZipFile(zip);
            return zipFile.entries();
        }
        catch (IOException ex) {
            throw new ZipUtilitiesException("An Exception has occured whilst accessing the file : " + zip.getAbsolutePath(), ex);
        }
    }

    public static Map getCRCS(File zip) throws ZipUtilitiesException {
        HashMap<String, Long> crcValues = new HashMap<String, Long>();
        Enumeration entries = ZipUtilities.listZipContents(zip);
        while (entries.hasMoreElements()) {
            ZipEntry entry = (ZipEntry)entries.nextElement();
            crcValues.put(entry.getName(), new Long(entry.getCrc()));
        }
        return crcValues;
    }

    public static boolean checkCRCS(File zip, Map crcExpected) throws ZipUtilitiesException {
        boolean returnValue = true;
        Map crcActual = ZipUtilities.getCRCS(zip);
        Set keys = crcExpected.keySet();
        for (Map.Entry me : keys) {
            String expectedFile = (String)me.getKey();
            Long expectedCRC = (Long)me.getValue();
            Object obj = crcActual.get(expectedFile);
            if (obj == null) {
                throw new ZipUtilitiesException("The expected zip contents did not match the actual zip contents, expected file : " + expectedFile, null);
            }
            Long actualCRC = (Long)obj;
            if (expectedCRC == actualCRC) continue;
            returnValue = false;
        }
        return returnValue;
    }

    public static boolean canAddFiles(long newFileSize, File zip, long maxZipSize, int maxZipEntries, int numFilesToAdd) throws ZipUtilitiesException {
        long zipSize = zip.length();
        if (maxZipSize < zipSize + newFileSize) {
            return false;
        }
        ZipFile zipfile = null;
        try {
            zipfile = new ZipFile(zip);
        }
        catch (IOException ex) {
            throw new ZipUtilitiesException("An error has occured whilst access the zip file : " + zip.getAbsolutePath(), ex);
        }
        int entryCount = zipfile.size();
        return maxZipEntries >= entryCount + numFilesToAdd;
    }

    public static class ZipUtilitiesException
    extends FileHandlerException {
        private static final long serialVersionUID = 1L;

        public ZipUtilitiesException(String message, Throwable error) {
            super(message, error);
        }
    }
}

