/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.jdbc;

import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import uk.gov.hmrc.chris.utils.jdbc.JDBCException;

public class BLOBHelper {
    public static OutputStream getOutputStream(Blob blob) throws JDBCException {
        try {
            return blob.setBinaryStream(1L);
        }
        catch (Exception e) {
            throw new JDBCException("Problem getting output stream from blob\n" + BLOBHelper.logInterfaces(blob), e);
        }
    }

    public static InputStream getInputStream(Blob blob) throws JDBCException {
        if (blob != null) {
            try {
                return blob.getBinaryStream();
            }
            catch (Exception e) {
                throw new JDBCException("Could not get input stream from blob", e);
            }
        }
        throw new JDBCException("Blob is null.  This is bad");
    }

    private static String logInterfaces(Object pObject) {
        StringBuffer sb = new StringBuffer();
        sb.append("Object interfaces\n");
        Class<?> cls = pObject.getClass();
        Class<?>[] impls = cls.getInterfaces();
        for (int i = 0; i < impls.length; ++i) {
            sb.append("Implments : ").append(impls[i].getName()).append("\n");
        }
        return sb.toString();
    }
}

