/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.jdbc;

import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import uk.gov.hmrc.chris.utils.jdbc.JDBCException;

public class CLOBHelper {
    public static Writer getWriter(Clob clob) throws JDBCException {
        try {
            return clob.setCharacterStream(1L);
        }
        catch (Exception e) {
            throw new JDBCException("Problem getting writer from clob\n" + CLOBHelper.logInterfaces(clob), e);
        }
    }

    public static Reader getReader(Clob clob) throws JDBCException {
        if (clob != null) {
            try {
                return clob.getCharacterStream();
            }
            catch (Exception e) {
                throw new JDBCException("Could not get reader from clob", e);
            }
        }
        throw new JDBCException("Clob is null.  This is bad");
    }

    private static String logInterfaces(Object pObject) {
        StringBuffer sb = new StringBuffer();
        sb.append("Object interfaces\n");
        Class<?> cls = pObject.getClass();
        Class<?>[] impls = cls.getInterfaces();
        for (int i = 0; i < impls.length; ++i) {
            sb.append("Implments : ").append(impls[i].getName()).append("\n");
        }
        return sb.toString();
    }
}

