/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.logging;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

public class AccessLogMessageDetails {
    private final Date date = new Date();
    private static final SimpleDateFormat FORMATTER = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private final String messagingTechnology;
    private final String messageSourceName;
    private final String messageReceiptAddress;
    private final String messageProcessingServerName;
    private final long creationTimestamp = System.currentTimeMillis();
    private String status = "200";

    public AccessLogMessageDetails(String messagingTechnology, String messageSourceName, String messageReceiptAddress) {
        this.messagingTechnology = messagingTechnology;
        this.messageSourceName = messageSourceName;
        this.messageReceiptAddress = messageReceiptAddress;
        this.messageProcessingServerName = StringUtils.isNotBlank((String)System.getProperty("name")) ? System.getProperty("name") : "Unknown_" + System.getProperty("user.name");
    }

    public String getMessagingTechnology() {
        return this.messagingTechnology;
    }

    public String getMessageReceiptAddress() {
        return this.messageReceiptAddress;
    }

    public void markAsFailed() {
        this.status = "500";
    }

    public void markAsRetry() {
        this.status = "503";
    }

    private String getDuration() {
        long duration = System.currentTimeMillis() - this.creationTimestamp;
        return String.format("%01d.%03d", duration / 1000L, duration % 1000L);
    }

    public String getDetails() {
        this.date.setTime(this.creationTimestamp);
        return this.messageSourceName + "|" + this.messageReceiptAddress + "|" + this.messageProcessingServerName + " " + this.status + " " + this.getDuration() + "*" + FORMATTER.format(this.date);
    }
}

