/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.logging;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import uk.gov.hmrc.chris.utils.ThreadLocalProxy;
import uk.gov.hmrc.chris.utils.logging.AOPLogger;
import uk.gov.hmrc.chris.utils.logging.AccessLogMessageDetails;
import uk.gov.hmrc.chris.utils.logging.IChrisLogFactory;

public class ChrisLogFactory
implements IChrisLogFactory {
    private static final Log DEFAULT_LOGGER = LogFactory.getLog((String)"chris");
    private static final String THREAD_LOCAL_KEY = "CHRIS_LOGGER";
    private static final String THREAD_LOCAL_KEY_SERVICE_TYPE = "CHRIS_SERVICE_TYPE";
    private static IChrisLogFactory instance = new ChrisLogFactory();

    public static void setInstance(IChrisLogFactory instance) {
        ChrisLogFactory.instance = instance;
    }

    public static void resetInstance() {
        instance = new ChrisLogFactory();
    }

    ChrisLogFactory() {
    }

    @Override
    public void initLogger(String serviceType, String lob, String messageClass) {
        String logName = "chris." + serviceType + "." + lob + "." + messageClass;
        Log log = LogFactory.getLog((String)logName.toLowerCase());
        ThreadLocalProxy.setThreadLocalObject(THREAD_LOCAL_KEY, log);
        ThreadLocalProxy.setThreadLocalObject(THREAD_LOCAL_KEY_SERVICE_TYPE, serviceType);
    }

    public static void init(String serviceType, String lob, String messageClass) {
        instance.initLogger(serviceType, lob, messageClass);
    }

    @Override
    public AOPLogger getLogger() {
        AOPLogger logger = (AOPLogger)ThreadLocalProxy.getThreadLocalObject(THREAD_LOCAL_KEY);
        if (logger == null) {
            return (AOPLogger)DEFAULT_LOGGER;
        }
        return logger;
    }

    public static AOPLogger getLog() {
        return instance.getLogger();
    }

    private static String getServiceType() {
        return (String)ThreadLocalProxy.getThreadLocalObject(THREAD_LOCAL_KEY_SERVICE_TYPE);
    }

    public static void logAccess(String lob, String messageClass, AccessLogMessageDetails details) {
        String logName = "chris.access." + details.getMessagingTechnology() + "." + lob + "." + ChrisLogFactory.getServiceType() + "." + messageClass;
        Log log = LogFactory.getLog((String)logName.toLowerCase());
        log.debug((Object)details.getDetails());
    }

    @Override
    public void closeLogger() {
        ThreadLocalProxy.setThreadLocalObject(THREAD_LOCAL_KEY, null);
        ThreadLocalProxy.setThreadLocalObject(THREAD_LOCAL_KEY_SERVICE_TYPE, null);
    }

    public static void close() {
        instance.closeLogger();
    }
}

