/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.logging;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.aopalliance.intercept.MethodInvocation;
import uk.gov.hmrc.chris.utils.logging.AOPLogger;
import uk.gov.hmrc.chris.utils.logging.LoggingFormatter;

public final class Jdk14ChrisLogger
implements AOPLogger {
    private final transient Logger logger;

    public Jdk14ChrisLogger(String name) {
        this.logger = Logger.getLogger(name);
    }

    Jdk14ChrisLogger(Logger log) {
        this.logger = log;
    }

    protected void log(Level level, Object msg, Throwable ex) {
        if (this.logger.isLoggable(level)) {
            Throwable dummyException = new Throwable();
            StackTraceElement[] locations = dummyException.getStackTrace();
            String cname = "unknown";
            String method = "unknown";
            String formattedMsg = (String)LoggingFormatter.format(msg);
            if (locations != null && locations.length > 2) {
                StackTraceElement caller = locations[2];
                cname = caller.getClassName();
                if (cname.contains("ChRIS") && cname.endsWith("Logger")) {
                    caller = locations[3];
                    cname = caller.getClassName();
                }
                method = caller.getMethodName();
            }
            if (ex == null) {
                this.logger.logp(level, cname, method, formattedMsg);
            } else {
                this.logger.logp(level, cname, method, formattedMsg, ex);
            }
        }
    }

    @Override
    public void aopTrace(Object msg, MethodInvocation invocation) {
        String formattedMsg = (String)LoggingFormatter.format(msg);
        this.logger.logp(Level.FINEST, invocation.getThis().getClass().getName(), invocation.getMethod().getName(), formattedMsg);
    }

    public boolean isTraceEnabled() {
        return this.logger.isLoggable(Level.FINEST);
    }

    public void trace(Object msg) {
        this.log(Level.FINEST, msg, null);
    }

    public void trace(Object msg, Throwable exception) {
        this.log(Level.FINEST, msg, exception);
    }

    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    public void debug(Object msg) {
        this.log(Level.FINE, msg, null);
    }

    public void debug(Object msg, Throwable exception) {
        this.log(Level.FINE, msg, exception);
    }

    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    public void info(Object msg) {
        this.log(Level.INFO, msg, null);
    }

    public void info(Object msg, Throwable exception) {
        this.log(Level.INFO, msg, exception);
    }

    public boolean isWarnEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    public void warn(Object msg) {
        this.log(Level.WARNING, msg, null);
    }

    public void warn(Object msg, Throwable exception) {
        this.log(Level.WARNING, msg, exception);
    }

    public boolean isErrorEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    public void error(Object msg) {
        this.log(Level.SEVERE, msg, null);
    }

    public void error(Object msg, Throwable exception) {
        this.log(Level.SEVERE, msg, exception);
    }

    public boolean isFatalEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    public void fatal(Object msg) {
        this.log(Level.SEVERE, msg, null);
    }

    public void fatal(Object msg, Throwable exception) {
        this.log(Level.SEVERE, msg, exception);
    }
}

