/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.logging;

import org.aopalliance.intercept.MethodInvocation;
import uk.gov.hmrc.chris.utils.connector.messagecontext.MessageContextUtil;

public final class LoggingFormatter {
    private LoggingFormatter() {
    }

    public static String getInvocationDescription(MethodInvocation invocation) {
        return invocation.getThis().getClass().getSimpleName() + "." + invocation.getMethod().getName();
    }

    static String getParameters(MethodInvocation invocation) {
        StringBuffer params = new StringBuffer("(");
        Object[] arguments = invocation.getArguments();
        for (int i = 0; i < arguments.length; ++i) {
            params.append(arguments[i]);
            if (i >= arguments.length - 1) continue;
            params.append(',');
        }
        params.append(')');
        return params.toString();
    }

    public static String formatMethodEntry(MethodInvocation invocation) {
        return "Entering " + LoggingFormatter.getInvocationDescription(invocation) + LoggingFormatter.getParameters(invocation);
    }

    public static String formatMethodReturn(MethodInvocation invocation, Object returnVal) {
        boolean isVoid = invocation.getMethod().getReturnType() == Void.TYPE;
        String retParam = "";
        if (!isVoid) {
            retParam = " returning: " + returnVal;
        }
        return "Exiting " + LoggingFormatter.getInvocationDescription(invocation) + "()" + retParam;
    }

    public static String formatMethodException(MethodInvocation invocation, Throwable exception) {
        return "Exception thrown in " + LoggingFormatter.getInvocationDescription(invocation) + "() : " + exception.getClass().getName();
    }

    public static String formatSQL(String sql) {
        return "SQL: " + sql;
    }

    public static Object format(Object message) {
        return "[" + MessageContextUtil.getConversationId() + "] " + message;
    }
}

