/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.logging;

import net.sf.cglib.proxy.Enhancer;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import uk.gov.hmrc.chris.utils.logging.AOPLogger;
import uk.gov.hmrc.chris.utils.logging.ChrisLogFactory;
import uk.gov.hmrc.chris.utils.logging.IAddTrace;
import uk.gov.hmrc.chris.utils.logging.LoggingFormatter;
import uk.gov.hmrc.chris.utils.logging.TraceExceptionProxyFactory;

public class LoggingInterceptor
implements MethodInterceptor {
    public Object invoke(MethodInvocation invocation) throws Throwable {
        AOPLogger logger = ChrisLogFactory.getLog();
        if (logger.isTraceEnabled()) {
            logger.aopTrace(LoggingFormatter.formatMethodEntry(invocation), invocation);
        }
        try {
            Object rval = invocation.proceed();
            if (logger.isTraceEnabled()) {
                logger.aopTrace(LoggingFormatter.formatMethodReturn(invocation, rval), invocation);
            }
            return rval;
        }
        catch (Throwable e) {
            if (logger.isTraceEnabled()) {
                logger.aopTrace(LoggingFormatter.formatMethodException(invocation, e), invocation);
            }
            if (!Enhancer.isEnhanced(e.getClass())) {
                TraceExceptionProxyFactory te = new TraceExceptionProxyFactory(e);
                e = te.createDecoratedException();
            }
            if (Enhancer.isEnhanced(e.getClass())) {
                ((IAddTrace)((Object)e)).addTrace(LoggingFormatter.formatMethodEntry(invocation));
            }
            throw e;
        }
    }
}

