/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.logging;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import uk.gov.hmrc.chris.utils.connector.messagecontext.MessageContextUtil;
import uk.gov.hmrc.chris.utils.logging.IAddTrace;

public class TraceExceptionProxyFactory
implements MethodInterceptor,
IAddTrace,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<String> traceList = new ArrayList<String>();
    private final Throwable throwable;

    public TraceExceptionProxyFactory(Throwable throwable) {
        this.throwable = throwable;
    }

    public Throwable createDecoratedException() {
        Enhancer e = new Enhancer();
        e.setSuperclass(this.throwable.getClass());
        e.setCallback((Callback)this);
        e.setInterfaces(new Class[]{IAddTrace.class, Serializable.class});
        try {
            return (Throwable)e.create(new Class[]{String.class}, new Object[]{null});
        }
        catch (Throwable ignore) {
            try {
                return (Throwable)e.create(new Class[]{String.class, Throwable.class}, new Object[]{null, null});
            }
            catch (Throwable ignore2) {
                try {
                    return (Throwable)e.create();
                }
                catch (Throwable ignore3) {
                    return this.throwable;
                }
            }
        }
    }

    @Override
    public void addTrace(String trace) {
        this.traceList.add(trace);
    }

    @Override
    public Throwable getOriginalUndecoratedException() {
        return this.throwable;
    }

    public void printStackTrace(PrintStream err) {
        err.println();
        if (MessageContextUtil.getMessageContext() != null) {
            err.println("Context:");
            err.println("\tConvId: " + MessageContextUtil.getConversationId());
            err.println("\tCaptId: " + MessageContextUtil.getMessageContext().getCorrelationId());
            err.println("\tServId: " + MessageContextUtil.getMessageContext().getServiceId());
            err.println("\tRoute : " + MessageContextUtil.getMessageContext().getRoute());
            err.println("\tMsgCls: " + MessageContextUtil.getMessageContext().getMessageClass());
            err.println("\tLob   : " + MessageContextUtil.getMessageContext().getLob());
        }
        err.println("Trace:");
        for (String trace : this.traceList) {
            err.println("\t" + trace);
        }
        this.throwable.printStackTrace(err);
    }

    public void printStackTrace(PrintWriter err) {
        err.println();
        if (MessageContextUtil.getMessageContext() != null) {
            err.println("Context:");
            err.println("\tConvId: " + MessageContextUtil.getConversationId());
            err.println("\tCaptId: " + MessageContextUtil.getMessageContext().getCorrelationId());
            err.println("\tServId: " + MessageContextUtil.getMessageContext().getServiceId());
            err.println("\tRoute : " + MessageContextUtil.getMessageContext().getRoute());
            err.println("\tMsgCls: " + MessageContextUtil.getMessageContext().getMessageClass());
            err.println("\tLob   : " + MessageContextUtil.getMessageContext().getLob());
        }
        err.println("Trace:");
        for (String trace : this.traceList) {
            err.println("\t" + trace);
        }
        this.throwable.printStackTrace(err);
    }

    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        if ("addTrace".equals(method.getName())) {
            this.addTrace((String)args[0]);
            return null;
        }
        if ("getOriginalUndecoratedException".equals(method.getName())) {
            return this.getOriginalUndecoratedException();
        }
        if ("fillInStackTrace".equals(method.getName())) {
            return null;
        }
        if ("printStackTrace".equals(method.getName())) {
            if (args[0] instanceof PrintStream) {
                this.printStackTrace((PrintStream)args[0]);
            } else {
                this.printStackTrace((PrintWriter)args[0]);
            }
            return null;
        }
        return method.invoke((Object)this.throwable, args);
    }
}

