/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.hmrc.chris.utils.logging.formatting;

import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.LogManager;
import org.apache.commons.lang.StringUtils;

public class ChrisNormalLogFileHandler
extends FileHandler {
    private static final String PATTERN_SUBSTITUTION_SUBSTRING = "JVM";

    protected static String getMessageProcessingServerName() {
        if (StringUtils.isNotBlank((String)System.getProperty("name"))) {
            return System.getProperty("name");
        }
        return "Unknown_" + System.getProperty("user.name");
    }

    protected static final String getUpdatedPattern(String className) {
        String origPattern = LogManager.getLogManager().getProperty(className + ".pattern");
        if (origPattern == null) {
            return "%h/wlslogs/LoggingConfigMissing_JVM%u.%g.log";
        }
        if (origPattern.indexOf(PATTERN_SUBSTITUTION_SUBSTRING) == -1) {
            return origPattern;
        }
        return origPattern.substring(0, origPattern.indexOf(PATTERN_SUBSTITUTION_SUBSTRING)) + ChrisNormalLogFileHandler.getMessageProcessingServerName() + origPattern.substring(origPattern.indexOf(PATTERN_SUBSTITUTION_SUBSTRING) + PATTERN_SUBSTITUTION_SUBSTRING.length());
    }

    protected static final int getLimit(String className) {
        return Integer.parseInt(LogManager.getLogManager().getProperty(className + ".limit"));
    }

    protected static final int getCount(String className) {
        return Integer.parseInt(LogManager.getLogManager().getProperty(className + ".count"));
    }

    public ChrisNormalLogFileHandler() throws IOException, SecurityException {
        super(ChrisNormalLogFileHandler.getUpdatedPattern(ChrisNormalLogFileHandler.class.getName()), ChrisNormalLogFileHandler.getLimit(ChrisNormalLogFileHandler.class.getName()), ChrisNormalLogFileHandler.getCount(ChrisNormalLogFileHandler.class.getName()));
    }

    public ChrisNormalLogFileHandler(String className) throws SecurityException, IOException {
        super(ChrisNormalLogFileHandler.getUpdatedPattern(className), ChrisNormalLogFileHandler.getLimit(className), ChrisNormalLogFileHandler.getCount(className));
    }
}

